// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DBRep_IsoBuilder_HeaderFile
#define _DBRep_IsoBuilder_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Geom2dHatch_Hatcher_HeaderFile
#include <Geom2dHatch_Hatcher.hxx>
#endif
#ifndef _Handle_DBRep_Face_HeaderFile
#include <Handle_DBRep_Face.hxx>
#endif
class TopoDS_Face;
class DBRep_Face;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Creation of isoparametric curves. <br>
class DBRep_IsoBuilder  : public Geom2dHatch_Hatcher {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates the builder. <br>
Standard_EXPORT DBRep_IsoBuilder(const TopoDS_Face& TopologicalFace,const Standard_Real Infinite,const Standard_Integer NbIsos);
//! Returns the total number of domains. <br>
  Standard_Integer NbDomains() const;

//! Loading of the isoparametric curves in the <br>
//!          Data Structure of a drawable face. <br>
Standard_EXPORT   void LoadIsos(const Handle(DBRep_Face)& Face) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myInfinite;
Standard_Real myUMin;
Standard_Real myUMax;
Standard_Real myVMin;
Standard_Real myVMax;
TColStd_Array1OfReal myUPrm;
TColStd_Array1OfInteger myUInd;
TColStd_Array1OfReal myVPrm;
TColStd_Array1OfInteger myVInd;
Standard_Integer myNbDom;


};


#include <DBRep_IsoBuilder.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
