// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2dConvert_BSplineCurveToBezierCurve_HeaderFile
#define _Geom2dConvert_BSplineCurveToBezierCurve_HeaderFile

#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_BezierCurve_HeaderFile
#include <Handle_Geom2d_BezierCurve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Geom2d_BSplineCurve;
class Standard_DimensionError;
class Standard_DomainError;
class Standard_OutOfRange;
class Geom2d_BezierCurve;
class TColGeom2d_Array1OfBezierCurve;
class TColStd_Array1OfReal;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!An algorithm to convert a BSpline curve into a series <br>
//! of adjacent Bezier curves. <br>
//! A BSplineCurveToBezierCurve object provides a framework for: <br>
//! -   defining the BSpline curve to be converted <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. <br>
//!  References : <br>
//!  Generating the Bezier points of B-spline curves and surfaces <br>
//!  (Wolfgang Bohm) CAD volume 13 number 6 november 1981 <br>
class Geom2dConvert_BSplineCurveToBezierCurve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Computes all the data needed to convert <br>
//! -   the BSpline curve BasisCurve, into a series of adjacent Bezier arcs. <br>
//! The result consists of a series of BasisCurve arcs <br>
//! limited by points corresponding to knot values of the curve. <br>
//! Use the available interrogation functions to ascertain <br>
//! the number of computed Bezier arcs, and then to <br>
//! construct each individual Bezier curve (or all Bezier curves). <br>
//! Note: ParametricTolerance is not used. <br>
Standard_EXPORT Geom2dConvert_BSplineCurveToBezierCurve(const Handle(Geom2d_BSplineCurve)& BasisCurve);

//! Computes all the data needed to convert <br>
//!        the portion of the BSpline curve BasisCurve <br>
//!   limited by the two parameter values U1 and U2 <br>
//!       for Example if there is a Knot Uk and <br>
//!  Uk < U < Uk + ParametricTolerance/2 the last curve <br>
//!  corresponds to the span [Uk-1, Uk] and not to  [Uk, Uk+1] <br>
//! The result consists of a series of BasisCurve arcs <br>
//! limited by points corresponding to knot values of the curve. <br>
//! Use the available interrogation functions to ascertain <br>
//! the number of computed Bezier arcs, and then to <br>
//! construct each individual Bezier curve (or all Bezier curves). <br>
//! Note: ParametricTolerance is not used. <br>
//!  Raises DomainError if U1 or U2 are out of the parametric bounds of the basis <br>
//!  curve [FirstParameter, LastParameter]. The Tolerance criterion <br>
//!  is ParametricTolerance. <br>
//!  Raised if Abs (U2 - U1) <= ParametricTolerance. <br>
Standard_EXPORT Geom2dConvert_BSplineCurveToBezierCurve(const Handle(Geom2d_BSplineCurve)& BasisCurve,const Standard_Real U1,const Standard_Real U2,const Standard_Real ParametricTolerance);

//!Constructs and returns the Bezier curve of index <br>
//! Index to the table of adjacent Bezier arcs <br>
//! computed by this algorithm. <br>
//! This Bezier curve has the same orientation as the <br>
//! BSpline curve analyzed in this framework. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is less than 1 or <br>
//! greater than the number of adjacent Bezier arcs <br>
//! computed by this algorithm. <br>
Standard_EXPORT   Handle_Geom2d_BezierCurve Arc(const Standard_Integer Index) ;

//!Constructs all the Bezier curves whose data is <br>
//! computed by this algorithm and loads these curves <br>
//! into the Curves table. <br>
//! The Bezier curves have the same orientation as the <br>
//! BSpline curve analyzed in this framework. <br>
//! Exceptions <br>
//! Standard_DimensionError if the Curves array was <br>
//! not created with the following bounds: <br>
//! -   1 , and <br>
//! -   the number of adjacent Bezier arcs computed by <br>
//!   this algorithm (as given by the function NbArcs). <br>
Standard_EXPORT   void Arcs(TColGeom2d_Array1OfBezierCurve& Curves) ;

//! This methode returns the bspline's knots associated to <br>
//!          the converted arcs <br>
//! Raises DimensionError if the length  of Curves is not equal to <br>
//!  NbArcs +  1 <br>
Standard_EXPORT   void Knots(TColStd_Array1OfReal& TKnots) const;


//!  Returns the number of BezierCurve arcs. <br>
//!  If at the creation time you have decomposed the basis curve <br>
//!  between the parametric values UFirst, ULast the number of <br>
//!  BezierCurve arcs depends on the number of knots included inside <br>
//!  the interval [UFirst, ULast]. <br>
//!  If you have decomposed the whole basis B-spline curve the number <br>
//!  of BezierCurve arcs NbArcs is equal to the number of knots less <br>
//!  one. <br>
Standard_EXPORT   Standard_Integer NbArcs() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom2d_BSplineCurve myCurve;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
