// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SelectSuite_HeaderFile
#define _IFSelect_SelectSuite_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_SelectSuite_HeaderFile
#include <Handle_IFSelect_SelectSuite.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _TColStd_SequenceOfTransient_HeaderFile
#include <TColStd_SequenceOfTransient.hxx>
#endif
#ifndef _IFSelect_SelectDeduct_HeaderFile
#include <IFSelect_SelectDeduct.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_IFSelect_Selection_HeaderFile
#include <Handle_IFSelect_Selection.hxx>
#endif
#ifndef _Handle_IFSelect_SelectDeduct_HeaderFile
#include <Handle_IFSelect_SelectDeduct.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class Interface_InterfaceError;
class IFSelect_Selection;
class IFSelect_SelectDeduct;
class Interface_EntityIterator;
class Interface_Graph;
class TCollection_AsciiString;


//! A SelectSuite can describe a suite of SelectDeduct as a unique <br>
//!           one : in other words, it can be seen as a "macro selection" <br>
//! <br>
//!           It works by applying each of its items (which is a <br>
//!           SelectDeduct) on the result computed by the previous one <br>
//!           (by using Alternate Input) <br>
//! <br>
//!           But each of these Selections used as items may be used <br>
//!           independently, it will then give its own result <br>
//! <br>
//!           Hence, SelectSuite gives a way of defining a new Selection <br>
//!           from existing ones, without having to do copies or saves <br>
class IFSelect_SelectSuite : public IFSelect_SelectDeduct {

public:
 // Methods PUBLIC
 // 

//! Creates an empty SelectSuite <br>
Standard_EXPORT IFSelect_SelectSuite();

//! Adds an input selection. I.E. : <br>
//!           If <item> is a SelectDeduct, adds it as Previous, not as Input <br>
//!           Else, sets it as Input <br>
//!           Returns True when done <br>
//!           Returns False and refuses to work if Input is already defined <br>
Standard_EXPORT   Standard_Boolean AddInput(const Handle(IFSelect_Selection)& item) ;

//! Adds a new first item (prepends to the list). The Input is not <br>
//!           touched <br>
//!           If <item> is null, does nothing <br>
Standard_EXPORT   void AddPrevious(const Handle(IFSelect_SelectDeduct)& item) ;

//! Adds a new last item (prepends to the list) <br>
//!           If <item> is null, does nothing <br>
Standard_EXPORT   void AddNext(const Handle(IFSelect_SelectDeduct)& item) ;

//! Returns the count of Items <br>
Standard_EXPORT   Standard_Integer NbItems() const;

//! Returns an item from its rank in the list <br>
//!           (the Input is always apart) <br>
Standard_EXPORT   Handle_IFSelect_SelectDeduct Item(const Standard_Integer num) const;

//! Sets a value for the Label <br>
Standard_EXPORT   void SetLabel(const Standard_CString lab) ;

//! Returns the list of selected entities <br>
//!           To do this, once InputResult has been taken (if Input or <br>
//!           Alternate has been defined, else the first Item gives it) : <br>
//!           this result is set as alternate input for the first item, <br>
//!           which computes its result : this result is set as alternate <br>
//!           input for the second item, etc... <br>
Standard_EXPORT   Interface_EntityIterator RootResult(const Interface_Graph& G) const;

//! Returns the Label <br>
//!           Either it has been defined by SetLabel, or it will give <br>
//!           "Suite of nn Selections" <br>
Standard_EXPORT   TCollection_AsciiString Label() const;
//Standard_EXPORT ~IFSelect_SelectSuite();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString thelab;
TColStd_SequenceOfTransient thesel;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
