// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESCAFControl_HeaderFile
#define _IGESCAFControl_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Quantity_Color;
class IGESCAFControl_Reader;
class IGESCAFControl_Writer;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides high-level API to translate IGES file <br>
//!          to and from DECAF document <br>
class IGESCAFControl  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Converts IGES color index to CASCADE color <br>
Standard_EXPORT static  Quantity_Color DecodeColor(const Standard_Integer col) ;

//! Tries to Convert CASCADE color to IGES color index <br>
//!          If no corresponding color defined in IGES, returns 0 <br>
Standard_EXPORT static  Standard_Integer EncodeColor(const Quantity_Color& col) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class IGESCAFControl_Reader;
friend class IGESCAFControl_Writer;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
