// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_AutoCorrect_HeaderFile
#define _IGESSelect_AutoCorrect_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_AutoCorrect_HeaderFile
#include <Handle_IGESSelect_AutoCorrect.hxx>
#endif

#ifndef _IGESSelect_ModelModifier_HeaderFile
#include <IGESSelect_ModelModifier.hxx>
#endif
#ifndef _Handle_IGESData_IGESModel_HeaderFile
#include <Handle_IGESData_IGESModel.hxx>
#endif
class IFSelect_ContextModif;
class IGESData_IGESModel;
class Interface_CopyTool;
class TCollection_AsciiString;


//! Does the absolutely effective corrections on IGES Entity. <br>
//!           That is to say : regarding the norm in details, some values <br>
//!           have mandatory values, or set of values with constraints. <br>
//!           When such values/constraints are univoque, they can be forced. <br>
//!           Also nullifies items of Directory Part, Associativities, and <br>
//!           Properties, which are not (or not longer) in <target> Model. <br>
//! <br>
//!           Works by calling a BasicEditor from IGESData <br>
//!           Works with the specific IGES Services : DirChecker which <br>
//!           allows to correct data in "Directory Part" of Entities (such <br>
//!           as required values for status, or references to be null), and <br>
//!           the specific IGES service OwnCorrect, which is specialised for <br>
//!           each type of entity. <br>
//! <br>
//!           Remark : this does not comprise the computation of use flag or <br>
//!           subordinate status according references, which is made by <br>
//!           the ModelModifier class ComputeStatus. <br>
//! <br>
//!           The Input Selection, when present, designates the entities to <br>
//!           be corrected. If it is not present, all the entities of the <br>
//!           model are corrected. <br>
class IGESSelect_AutoCorrect : public IGESSelect_ModelModifier {

public:
 // Methods PUBLIC
 // 

//! Creates an AutoCorrect. <br>
Standard_EXPORT IGESSelect_AutoCorrect();

//! Specific action : corrects entities when it is absolutely <br>
//!           obvious, i.e. non equivoque (by DirChecker and specific <br>
//!           service OwnCorrect) : works with a protocol. <br>
Standard_EXPORT   void Performing(IFSelect_ContextModif& ctx,const Handle(IGESData_IGESModel)& target,Interface_CopyTool& TC) const;

//! Returns a text which is <br>
//!           "Auto-correction of IGES Entities" <br>
Standard_EXPORT   TCollection_AsciiString Label() const;
//Standard_EXPORT ~IGESSelect_AutoCorrect();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
