// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_SelectBasicGeom_HeaderFile
#define _IGESSelect_SelectBasicGeom_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_SelectBasicGeom_HeaderFile
#include <Handle_IGESSelect_SelectBasicGeom.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _IFSelect_SelectExplore_HeaderFile
#include <IFSelect_SelectExplore.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
class Standard_Transient;
class Interface_Graph;
class Interface_EntityIterator;
class TCollection_AsciiString;
class IGESData_IGESEntity;


//! This selection returns the basic geometric elements <br>
//!           contained in an IGES Entity <br>
//!           Intended to run a "quick" transfer. I.E. : <br>
//!           - for a Group, considers its Elements <br>
//!           - for a Trimmed or Bounded Surface or a Face (BREP), <br>
//!             considers the 3D curves of each of its loops <br>
//!           - for a Plane (108), considers its Bounding Curve <br>
//!           - for a Curve itself, takes it <br>
//! <br>
//!           Also, FREE surfaces are taken, because curve 3d is known for <br>
//!           them. (the ideal should be to have their natural bounds) <br>
//! <br>
//!           If <curvesonly> is set, ONLY curves-3d are returned <br>
class IGESSelect_SelectBasicGeom : public IFSelect_SelectExplore {

public:
 // Methods PUBLIC
 // 

//! Creates a SelectBasicGeom, which allways works recursively <br>
//!           mode = -1 : Returns Surfaces (without trimming) <br>
//!           mode = +1 : Returns Curves 3D (free or bound of surface) <br>
//!           mode = +2 : Returns Basic Curves 3D : as 1 but CompositeCurves <br>
//!                        are returned in detail <br>
//!           mode = 0  : both <br>
Standard_EXPORT IGESSelect_SelectBasicGeom(const Standard_Integer mode);


Standard_EXPORT   Standard_Boolean CurvesOnly() const;

//! Explores an entity, to take its contained Curves 3d <br>
//!           Works recursively <br>
Standard_EXPORT   Standard_Boolean Explore(const Standard_Integer level,const Handle(Standard_Transient)& ent,const Interface_Graph& G,Interface_EntityIterator& explored) const;

//! Returns a text defining the criterium : "Curves 3d" or <br>
//!           "Basic Geometry" <br>
Standard_EXPORT   TCollection_AsciiString ExploreLabel() const;

//! This method can be called from everywhere to get the curves <br>
//!           as sub-elements of a given curve : <br>
//!           CompositeCurve : explored lists its subs + returns True <br>
//!           Any Curve : explored is not filled but returned is True <br>
//!           Other : returned is False <br>
Standard_EXPORT static  Standard_Boolean SubCurves(const Handle(IGESData_IGESEntity)& ent,Interface_EntityIterator& explored) ;
//Standard_EXPORT ~IGESSelect_SelectBasicGeom();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer thegeom;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
