// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSolid_SolidAssembly_HeaderFile
#define _IGESSolid_SolidAssembly_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSolid_SolidAssembly_HeaderFile
#include <Handle_IGESSolid_SolidAssembly.hxx>
#endif

#ifndef _Handle_IGESData_HArray1OfIGESEntity_HeaderFile
#include <Handle_IGESData_HArray1OfIGESEntity.hxx>
#endif
#ifndef _Handle_IGESGeom_HArray1OfTransformationMatrix_HeaderFile
#include <Handle_IGESGeom_HArray1OfTransformationMatrix.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_IGESGeom_TransformationMatrix_HeaderFile
#include <Handle_IGESGeom_TransformationMatrix.hxx>
#endif
class IGESData_HArray1OfIGESEntity;
class IGESGeom_HArray1OfTransformationMatrix;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class IGESData_IGESEntity;
class IGESGeom_TransformationMatrix;


//! defines SolidAssembly, Type <184> Form <0> <br>
//!          in package IGESSolid <br>
//!          Solid assembly is a collection of items which possess a <br>
//!          shared fixed geometric relationship. <br>
//! <br>
//!          From IGES-5.3, From 1 says that at least one item is a Brep <br>
//!          else all are Primitives, Boolean Trees, Solid Instances or <br>
//!          other Assemblies <br>
class IGESSolid_SolidAssembly : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESSolid_SolidAssembly();

//! This method is used to set the fields of the class <br>
//!           SolidAssembly <br>
//!       - allItems    : the collection of items <br>
//!       - allMatrices : transformation matrices corresponding to each <br>
//!                       item <br>
//! raises exception if the length of allItems & allMatrices <br>
//! do not match <br>
Standard_EXPORT   void Init(const Handle(IGESData_HArray1OfIGESEntity)& allItems,const Handle(IGESGeom_HArray1OfTransformationMatrix)& allMatrices) ;

//! Tells if at least one item is a Brep, from FormNumber <br>
Standard_EXPORT   Standard_Boolean HasBrep() const;

//! Sets or Unsets the status "HasBrep" from FormNumber <br>
//!           Default is False <br>
Standard_EXPORT   void SetBrep(const Standard_Boolean hasbrep) ;

//! returns the number of items in the collection <br>
Standard_EXPORT   Standard_Integer NbItems() const;

//! returns the Index'th item <br>
//! raises exception if Index <= 0 or Index > NbItems() <br>
Standard_EXPORT   Handle_IGESData_IGESEntity Item(const Standard_Integer Index) const;

//! returns the transformation matrix of the Index'th item <br>
//! raises exception if Index <= 0 or Index > NbItems() <br>
Standard_EXPORT   Handle_IGESGeom_TransformationMatrix TransfMatrix(const Standard_Integer Index) const;
//Standard_EXPORT ~IGESSolid_SolidAssembly();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESData_HArray1OfIGESEntity theItems;
Handle_IGESGeom_HArray1OfTransformationMatrix theMatrices;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
