// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Image_Convertor_HeaderFile
#define _Image_Convertor_HeaderFile

#ifndef _Image_DitheringMethod_HeaderFile
#include <Image_DitheringMethod.hxx>
#endif
#ifndef _Handle_Image_PseudoColorImage_HeaderFile
#include <Handle_Image_PseudoColorImage.hxx>
#endif
#ifndef _Handle_Image_ColorImage_HeaderFile
#include <Handle_Image_ColorImage.hxx>
#endif
#ifndef _Handle_Aspect_ColorMap_HeaderFile
#include <Handle_Aspect_ColorMap.hxx>
#endif
class Image_PseudoColorImage;
class Image_ColorImage;
class Aspect_ColorMap;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class is used to convert : <br>
//!		a PseudoColorImage to a ColorImage <br>
//!		a ColorImage to a PseudoColorImage <br>
//!		a PseudoColorImage to a PseudoColorImage with a <br>
//!			different ColorMap. <br>
class Image_Convertor  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Create a Convertor object with the default DitheringMethod <br>
//!	( DM_NearestColor ). <br>
Standard_EXPORT Image_Convertor();

//! Set DitheringMethod. <br>
Standard_EXPORT   void SetDitheringMethod(const Image_DitheringMethod aMethod) ;

//! Dither a ColorImage into a PseudoColorImage using the <br>
//!		 ColorMap parameter. <br>
Standard_EXPORT   Handle_Image_PseudoColorImage Convert(const Handle(Image_ColorImage)& aColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;

//! Dither a PseudoColorImage into a PseudoColorImage using the <br>
//!		 ColorMap parameter. <br>
Standard_EXPORT   Handle_Image_PseudoColorImage Convert(const Handle(Image_PseudoColorImage)& aPseudoColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;

//! Lookup a PseudoColorImage into a ColorImage using the <br>
//!		PseudoColorImage ColorMap. <br>
Standard_EXPORT   Handle_Image_ColorImage Convert(const Handle(Image_PseudoColorImage)& aPseudoColorImage) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Handle_Image_PseudoColorImage NearestDithering(const Handle(Image_ColorImage)& aColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;


Standard_EXPORT   Handle_Image_PseudoColorImage NearestDithering(const Handle(Image_PseudoColorImage)& aPseudoColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;


Standard_EXPORT   Handle_Image_PseudoColorImage ErrorDiffusionDithering(const Handle(Image_ColorImage)& aColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;


Standard_EXPORT   Handle_Image_PseudoColorImage ErrorDiffusionDithering(const Handle(Image_PseudoColorImage)& aPseudoColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;


 // Fields PRIVATE
 //
Image_DitheringMethod myDitheringMethod;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
