// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_CopyMap_HeaderFile
#define _Interface_CopyMap_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Interface_CopyMap_HeaderFile
#include <Handle_Interface_CopyMap.hxx>
#endif

#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _TColStd_Array1OfTransient_HeaderFile
#include <TColStd_Array1OfTransient.hxx>
#endif
#ifndef _Interface_CopyControl_HeaderFile
#include <Interface_CopyControl.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Interface_InterfaceModel;
class Interface_InterfaceError;
class Standard_Transient;


//! Manages a Map for the need of single Transfers, such as Copies <br>
//!           In such transfer, Starting Entities are read from a unique <br>
//!           Starting Model, and each transferred Entity is bound to one <br>
//!           and only one Result, which cannot be changed later. <br>
class Interface_CopyMap : public Interface_CopyControl {

public:
 // Methods PUBLIC
 // 

//! Creates a CopyMap adapted to work from a Model <br>
Standard_EXPORT Interface_CopyMap(const Handle(Interface_InterfaceModel)& amodel);

//! Clears Transfer List. Gets Ready to begin another Transfer <br>
Standard_EXPORT   void Clear() ;

//! Returns the InterfaceModel used at Creation time <br>
Standard_EXPORT   Handle_Interface_InterfaceModel Model() const;

//! Binds a Starting Entity identified by its Number <num> in the <br>
//!           Starting Model, to a Result of Transfer <res> <br>
Standard_EXPORT   void Bind(const Handle(Standard_Transient)& ent,const Handle(Standard_Transient)& res) ;

//! Search for the result of a Starting Object (i.e. an Entity, <br>
//!           identified by its Number <num> in the Starting Model) <br>
//!           Returns True  if a  Result is Bound (and fills <res>) <br>
//!           Returns False if no result is Bound (and nullifies <res>) <br>
Standard_EXPORT   Standard_Boolean Search(const Handle(Standard_Transient)& ent,Handle(Standard_Transient)& res) const;
//Standard_EXPORT ~Interface_CopyMap();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Interface_InterfaceModel themod;
TColStd_Array1OfTransient theres;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
