// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_ProgressScale_HeaderFile
#define _Message_ProgressScale_HeaderFile

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class TCollection_HAsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Internal data structure for scale in ProgressIndicator <br>
class Message_ProgressScale  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates scale ranged from 0 to 100 with step 1 <br>
Standard_EXPORT Message_ProgressScale();

  void SetName(const Standard_CString theName) ;
//! Sets scale name <br>
  void SetName(const Handle(TCollection_HAsciiString)& theName) ;
//! Gets scale name <br>
//!          Name may be Null handle if not set <br>
  Handle_TCollection_HAsciiString GetName() const;
//! Sets minimum value of scale <br>
  void SetMin(const Standard_Real theMin) ;
//! Gets minimum value of scale <br>
  Standard_Real GetMin() const;
//! Sets minimum value of scale <br>
  void SetMax(const Standard_Real theMax) ;
//! Gets minimum value of scale <br>
  Standard_Real GetMax() const;
//! Set both min and max <br>
  void SetRange(const Standard_Real min,const Standard_Real max) ;
//! Sets default step <br>
  void SetStep(const Standard_Real theStep) ;
//! Gets default step <br>
  Standard_Real GetStep() const;
//! Sets flag for infinite scale <br>
  void SetInfinite(const Standard_Boolean theInfinite = Standard_True) ;
//! Gets flag for infinite scale <br>
  Standard_Boolean GetInfinite() const;
//! Set all scale parameters <br>
  void SetScale(const Standard_Real min,const Standard_Real max,const Standard_Real step,const Standard_Boolean theInfinite = Standard_True) ;
//! Defines span occupied by the scale on the basis scale <br>
  void SetSpan(const Standard_Real first,const Standard_Real last) ;

  Standard_Real GetFirst() const;
//! Return information on span occupied by the scale on the base scale <br>
  Standard_Real GetLast() const;


Standard_EXPORT   Standard_Real LocalToBase(const Standard_Real val) const;

//! Convert value from this scale to base one and back <br>
Standard_EXPORT   Standard_Real BaseToLocal(const Standard_Real val) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString myName;
Standard_Real myMin;
Standard_Real myMax;
Standard_Real myStep;
Standard_Boolean myInfinite;
Standard_Real myFirst;
Standard_Real myLast;


};


#include <Message_ProgressScale.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
