// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Select3D_Projector_HeaderFile
#define _Select3D_Projector_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _gp_GTrsf_HeaderFile
#include <gp_GTrsf.hxx>
#endif
#ifndef _gp_Vec2d_HeaderFile
#include <gp_Vec2d.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
class V3d_View;
class Standard_NoSuchObject;
class gp_Ax2;
class gp_Trsf;
class gp_Vec2d;
class gp_GTrsf;
class gp_Vec;
class gp_Pnt;
class gp_Pnt2d;
class Bnd_Box;
class gp_Lin;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A framework to define 3D projectors. <br>
class Select3D_Projector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs the 3D projector object defined by the 3D view aView. <br>
Standard_EXPORT Select3D_Projector(const Handle(V3d_View)& aView);


Standard_EXPORT Select3D_Projector();

//! Creates   an axonometric  projector.   <CS> is the <br>
//!          viewing coordinate system. <br>
Standard_EXPORT Select3D_Projector(const gp_Ax2& CS);

//! Creates  a  perspective  projector.   <CS>  is the <br>
//!          viewing coordinate system. <br>
Standard_EXPORT Select3D_Projector(const gp_Ax2& CS,const Standard_Real Focus);

//! build a Projector with automatic minmax directions. <br>
Standard_EXPORT Select3D_Projector(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus);

//! build a Projector with given minmax directions. <br>
Standard_EXPORT Select3D_Projector(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus,const gp_Vec2d& v1,const gp_Vec2d& v2,const gp_Vec2d& v3);

//! build a Projector with automatic minmax directions. <br>
Standard_EXPORT Select3D_Projector(const gp_GTrsf& GT,const Standard_Boolean Persp,const Standard_Real Focus);


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~Select3D_Projector(){Delete() ; }


Standard_EXPORT   void Set(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus) ;

//! Sets the 3D view V used at the time of construction. <br>
Standard_EXPORT   void SetView(const Handle(V3d_View)& V) ;
//! Returns the 3D view used at the time of construction. <br>
 const Handle_V3d_View& View() const;

virtual  void Directions(gp_Vec2d& D1,gp_Vec2d& D2,gp_Vec2d& D3) const;

//! to compute with the given scale and translation. <br>
Standard_EXPORT virtual  void Scaled(const Standard_Boolean On = Standard_False) ;
//! Returns True if there is a perspective transformation. <br>
virtual  Standard_Boolean Perspective() const;
//! Returns the active transformation. <br>
virtual const gp_GTrsf& Transformation() const;
//! Returns the active inverted transformation. <br>
virtual const gp_GTrsf& InvertedTransformation() const;
//! Returns the original transformation. <br>
virtual const gp_Trsf& FullTransformation() const;
//! Returns the focal length. <br>
virtual  Standard_Real Focus() const;

virtual  void Transform(gp_Vec& D) const;

virtual  void Transform(gp_Pnt& Pnt) const;

//! Transform and apply perspective if needed. <br>
Standard_EXPORT virtual  void Project(const gp_Pnt& P,gp_Pnt2d& Pout) const;

//! Transform and apply perspective if needed. <br>
Standard_EXPORT   void Project(const gp_Pnt& P,Standard_Real& X,Standard_Real& Y,Standard_Real& Z) const;

//! Transform and apply perspective if needed. <br>
Standard_EXPORT virtual  void Project(const gp_Pnt& P,const gp_Vec& D1,gp_Pnt2d& Pout,gp_Vec2d& D1out) const;

//! Adds to the box <B> the min-max of the point <P>. <br>
Standard_EXPORT virtual  void BoxAdd(const gp_Pnt2d& P,Bnd_Box& B) const;

//! return a line going through the eye towards the <br>
//!          2d point <X,Y>. <br>
Standard_EXPORT virtual  gp_Lin Shoot(const Standard_Real X,const Standard_Real Y) const;

virtual  void Transform(gp_Pnt& P,const gp_GTrsf& T) const;

virtual  void Transform(gp_Lin& D,const gp_GTrsf& T) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Boolean myPersp;
Standard_Real myFocus;
gp_Trsf myScaledTrsf;
gp_GTrsf myGTrsf;
gp_GTrsf myInvTrsf;
gp_Vec2d myD1;
gp_Vec2d myD2;
gp_Vec2d myD3;


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void SetDirection() ;


 // Fields PRIVATE
 //
Standard_Integer myType;
Handle_V3d_View myView;


};


#include <Select3D_Projector.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
