// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_WireSegment_HeaderFile
#define _ShapeFix_WireSegment_HeaderFile

#ifndef _Handle_ShapeExtend_WireData_HeaderFile
#include <Handle_ShapeExtend_WireData.hxx>
#endif
#ifndef _TopoDS_Vertex_HeaderFile
#include <TopoDS_Vertex.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class ShapeExtend_WireData;
class TColStd_HSequenceOfInteger;
class TopoDS_Wire;
class TopoDS_Vertex;
class TopoDS_Edge;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class is auxiliary class used in ComposeShell. <br>
//!          It is intended for representing segment of the wire <br>
//!          (or whole wire). The segment itself is represented by <br>
//!          ShapeExtend_WireData. In addition, some associated data <br>
//!          necessary for computations are stored: <br>
class ShapeFix_WireSegment  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates empty segment. <br>
Standard_EXPORT ShapeFix_WireSegment();

//! Creates segment and initializes it with wire and orientation. <br>
Standard_EXPORT ShapeFix_WireSegment(const Handle(ShapeExtend_WireData)& wire,const TopAbs_Orientation ori = TopAbs_EXTERNAL);

//! Creates segment and initializes it with wire and orientation. <br>
Standard_EXPORT ShapeFix_WireSegment(const TopoDS_Wire& wire,const TopAbs_Orientation ori = TopAbs_EXTERNAL);

//! Clears all fields. <br>
Standard_EXPORT   void Clear() ;

//! Loads wire. <br>
Standard_EXPORT   void Load(const Handle(ShapeExtend_WireData)& wire) ;

//! Returns wire. <br>
Standard_EXPORT  const Handle_ShapeExtend_WireData& WireData() const;

//! Sets orientation flag. <br>
Standard_EXPORT   void Orientation(const TopAbs_Orientation ori) ;

//! Returns orientation flag. <br>
Standard_EXPORT   TopAbs_Orientation Orientation() const;

//! Returns first vertex of the first edge in the wire <br>
//!          (no dependance on Orientation()). <br>
Standard_EXPORT   TopoDS_Vertex FirstVertex() const;

//! Returns last vertex of the last edge in the wire <br>
//!          (no dependance on Orientation()). <br>
Standard_EXPORT   TopoDS_Vertex LastVertex() const;

//! Returns True if FirstVertex() == LastVertex() <br>
Standard_EXPORT   Standard_Boolean IsClosed() const;

//! Returns Number of edges in the wire <br>
Standard_EXPORT   Standard_Integer NbEdges() const;

//! Returns edge by given index in the wire <br>
Standard_EXPORT   TopoDS_Edge Edge(const Standard_Integer i) const;

//! Replaces edge at index i by new one. <br>
Standard_EXPORT   void SetEdge(const Standard_Integer i,const TopoDS_Edge& edge) ;

//! Insert a new edge with index i and implicitly defined <br>
//!          patch indices (indefinite patch). <br>
//!          If i==0, edge is inserted at end of wire. <br>
Standard_EXPORT   void AddEdge(const Standard_Integer i,const TopoDS_Edge& edge) ;

//! Insert a new edge with index i and explicitly defined <br>
//!          patch indices. If i==0, edge is inserted at end of wire. <br>
Standard_EXPORT   void AddEdge(const Standard_Integer i,const TopoDS_Edge& edge,const Standard_Integer iumin,const Standard_Integer iumax,const Standard_Integer ivmin,const Standard_Integer ivmax) ;

//! Set patch indices for edge i. <br>
Standard_EXPORT   void SetPatchIndex(const Standard_Integer i,const Standard_Integer iumin,const Standard_Integer iumax,const Standard_Integer ivmin,const Standard_Integer ivmax) ;


Standard_EXPORT   void DefineIUMin(const Standard_Integer i,const Standard_Integer iumin) ;


Standard_EXPORT   void DefineIUMax(const Standard_Integer i,const Standard_Integer iumax) ;


Standard_EXPORT   void DefineIVMin(const Standard_Integer i,const Standard_Integer ivmin) ;

//! Modify minimal or maximal patch index for edge i. <br>
//!          The corresponding patch index for that edge is modified so <br>
//!          as to satisfy eq. iumin <= myIUMin(i) <= myIUMax(i) <= iumax <br>
Standard_EXPORT   void DefineIVMax(const Standard_Integer i,const Standard_Integer ivmax) ;

//! Returns patch indices for edge i. <br>
Standard_EXPORT   void GetPatchIndex(const Standard_Integer i,Standard_Integer& iumin,Standard_Integer& iumax,Standard_Integer& ivmin,Standard_Integer& ivmax) const;

//! Checks patch indices for edge i to satisfy equations <br>
//!          IUMin(i) <= IUMax(i) <= IUMin(i)+1 <br>
Standard_EXPORT   Standard_Boolean CheckPatchIndex(const Standard_Integer i) const;


Standard_EXPORT   void SetVertex(const TopoDS_Vertex& theVertex) ;


Standard_EXPORT   TopoDS_Vertex GetVertex() const;


Standard_EXPORT   Standard_Boolean IsVertex() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_ShapeExtend_WireData myWire;
TopoDS_Vertex myVertex;
TopAbs_Orientation myOrient;
Handle_TColStd_HSequenceOfInteger myIUMin;
Handle_TColStd_HSequenceOfInteger myIUMax;
Handle_TColStd_HSequenceOfInteger myIVMin;
Handle_TColStd_HSequenceOfInteger myIVMax;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
