// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDF_ClosureTool_HeaderFile
#define _TDF_ClosureTool_HeaderFile

#ifndef _Handle_TDF_DataSet_HeaderFile
#include <Handle_TDF_DataSet.hxx>
#endif
class TDF_DataSet;
class TDF_IDFilter;
class TDF_ClosureMode;
class TDF_Label;
class TDF_LabelMap;
class TDF_AttributeMap;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides services to build the closure <br>
//!          of an information set. <br>
//! <br>
//!          You can set closure options by using IDFilter <br>
//!          (to select or exclude specific attribute IDs) and <br>
//!          CopyOption objects and by giving to Closure <br>
//!          method. <br>
//! <br>
class TDF_ClosureTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Builds the transitive closure of label and <br>
//!          attribute sets into <aDataSet>. <br>
Standard_EXPORT static  void Closure(const Handle(TDF_DataSet)& aDataSet) ;

//! Builds the transitive closure of label and <br>
//!          attribute sets into <aDataSet>. Uses <aFilter> to <br>
//!          determine if an attribute has to be taken in <br>
//!          account or not. Uses <aMode> for various way of <br>
//!          closing. <br>
Standard_EXPORT static  void Closure(const Handle(TDF_DataSet)& aDataSet,const TDF_IDFilter& aFilter,const TDF_ClosureMode& aMode) ;

//! Builds the transitive closure of <aLabel>. <br>
Standard_EXPORT static  void Closure(const TDF_Label& aLabel,TDF_LabelMap& aLabMap,TDF_AttributeMap& anAttMap,const TDF_IDFilter& aFilter,const TDF_ClosureMode& aMode) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Adds label attributes and dependences. <br>
Standard_EXPORT static  void LabelAttributes(const TDF_Label& aLabel,TDF_LabelMap& aLabMap,TDF_AttributeMap& anAttMap,const TDF_IDFilter& aFilter,const TDF_ClosureMode& aMode) ;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
