// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TNaming_ShapesSet_HeaderFile
#define _TNaming_ShapesSet_HeaderFile

#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopoDS_Shape;
class TopTools_MapOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TNaming_ShapesSet  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

TNaming_ShapesSet();


Standard_EXPORT TNaming_ShapesSet(const TopoDS_Shape& S,const TopAbs_ShapeEnum Type = TopAbs_SHAPE);
//! Removes all Shapes <br>
  void Clear() ;
//! Adds the Shape <S> <br>
  Standard_Boolean Add(const TopoDS_Shape& S) ;
//! Returns True  if <S> is in <me> <br>
  Standard_Boolean Contains(const TopoDS_Shape& S) const;
//! Removes <S> in <me>. <br>
  Standard_Boolean Remove(const TopoDS_Shape& S) ;

//! Adds the shapes contained in <Shapes>. <br>
Standard_EXPORT   void Add(const TNaming_ShapesSet& Shapes) ;

//! Erases in <me> the shapes not <br>
//!          contained in <Shapes> <br>
Standard_EXPORT   void Filter(const TNaming_ShapesSet& Shapes) ;

//! Removes in <me> the shapes contained in <Shapes> <br>
Standard_EXPORT   void Remove(const TNaming_ShapesSet& Shapes) ;

  Standard_Boolean IsEmpty() const;

  Standard_Integer NbShapes() const;

  TopTools_MapOfShape& ChangeMap() ;

 const TopTools_MapOfShape& Map() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopTools_MapOfShape myMap;


};


#include <TNaming_ShapesSet.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
