// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _V2d_DefaultMap_HeaderFile
#define _V2d_DefaultMap_HeaderFile

#ifndef _Handle_Aspect_GenericColorMap_HeaderFile
#include <Handle_Aspect_GenericColorMap.hxx>
#endif
#ifndef _Handle_Aspect_TypeMap_HeaderFile
#include <Handle_Aspect_TypeMap.hxx>
#endif
#ifndef _Handle_Aspect_WidthMap_HeaderFile
#include <Handle_Aspect_WidthMap.hxx>
#endif
#ifndef _Handle_Aspect_FontMap_HeaderFile
#include <Handle_Aspect_FontMap.hxx>
#endif
#ifndef _Handle_Aspect_MarkMap_HeaderFile
#include <Handle_Aspect_MarkMap.hxx>
#endif
class Aspect_GenericColorMap;
class Aspect_TypeMap;
class Aspect_WidthMap;
class Aspect_FontMap;
class Aspect_MarkMap;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!  Modifies class definition. <br>
class V2d_DefaultMap  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns a indexed color map with the following color <br>
//!          White, black, red, green, blue1 , yellow, sienna, orange2 <br>
//!          lightgray,lightseagreen,gray60,gray70. The index are 1 to 12. <br>
Standard_EXPORT static  Handle_Aspect_GenericColorMap ColorMap() ;

//! Returns a indexed type map with the following line types <br>
//!          SOLID, DASH, DOT, DOTDASH. The index are 1 to 4. <br>
Standard_EXPORT static  Handle_Aspect_TypeMap TypeMap() ;

//! Returns a indexed width map with the following width <br>
//!          0.0001, 0.0006, 0.001, 0.003. The index are 1 to 4. <br>
Standard_EXPORT static  Handle_Aspect_WidthMap WidthMap() ;

//! Returns a indexed font map with the following font <br>
//!          "Courier-Bold" 0.01 0.0 <br>
//!          "Helvetica-Bold" 0.01 0.2 <br>
//!          "-adobe-helvetica-medium-r-normal--12-120-75-75-p-67-iso8859-1" 0.003 0.0 <br>
//!          The index are 1 to 2. <br>
Standard_EXPORT static  Handle_Aspect_FontMap FontMap() ;

//! Returns a indexed font map with the following width <br>
//!          Point,Plus,Star,O,X,O_Point,O_Plus,O_STAR,O_X <br>
//!          BALL,RING1,RING2,RING3 <br>
Standard_EXPORT static  Handle_Aspect_MarkMap MarkMap() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
