
#define NOVIRTUAL

// File		OpenGl_GraphicDriver_3.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <OpenGl_GraphicDriver.jxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

extern "C" {
int GenerateMarkerBitmap( int theId, unsigned int theWidth, unsigned int theHeight, unsigned char* theArray);
}

//-Aliases

//-Global data definitions

//-Methods, in order

void OpenGl_GraphicDriver::ClearGroup (const Graphic3d_CGroup& ACGroup) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_cleargroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_cleargroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_cleargroup (&MyCGroup);

#endif
}

void OpenGl_GraphicDriver::CloseGroup (const Graphic3d_CGroup& ACGroup) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_closegroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_closegroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_closegroup (&MyCGroup);

#endif
}

void OpenGl_GraphicDriver::FaceContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_facecontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_facecontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_facecontextgroup (&MyCGroup, int (NoInsert));

#endif
}

void OpenGl_GraphicDriver::Group (Graphic3d_CGroup& ACGroup) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_group");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_group");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_group (&MyCGroup);

#endif
}

void OpenGl_GraphicDriver::LineContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_linecontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_linecontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_linecontextgroup (&MyCGroup, int (NoInsert));

#endif
}

void OpenGl_GraphicDriver::MarkerContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_markercontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_markercontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_markercontextgroup (&MyCGroup, int (NoInsert));

#endif
}

void OpenGl_GraphicDriver::MarkerContextGroup (const Graphic3d_CGroup& ACGroup, 
					       const Standard_Integer NoInsert,
                                               const Standard_Integer AMarkWidth,
                                               const Standard_Integer AMarkHeight,
                                               const Handle(Graphic3d_HArray1OfBytes)& ATexture ) 
{
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_markercontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}        
        int aByteWidth = AMarkWidth / 8;
//        if( AMarkWidth % 8 != 0 )
//             aByteWidth++;
        unsigned char *anArray = (unsigned char*) malloc(ATexture->Length());
        for( int anIndex = ATexture->Upper() - ATexture->Lower() - aByteWidth + 1; anIndex >= 0; anIndex -= aByteWidth )
	    for( int i = 0; i < aByteWidth; i++ )
		anArray[ATexture->Upper() - ATexture->Lower() - aByteWidth + 1 - anIndex + i ] = ATexture->Value( anIndex + i + 1 );

        //for( unsigned int anIndex = 0; anIndex < ATexture.Upper() - ATexture.Lower() + 1; anIndex++ )
	//	anArray[anIndex] = ATexture.Value( anIndex + 1 );
        
	GenerateMarkerBitmap( (int)ACGroup.ContextMarker.Scale, AMarkWidth, AMarkHeight, anArray );
	if (MyTraceLevel) {
		PrintFunction ("call_togl_markercontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_markercontextgroup (&MyCGroup, int (NoInsert));

        free(anArray);
#endif
}


void OpenGl_GraphicDriver::OpenGroup (const Graphic3d_CGroup& ACGroup) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_opengroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_opengroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_opengroup (&MyCGroup);

#endif
}

void OpenGl_GraphicDriver::RemoveGroup (const Graphic3d_CGroup& ACGroup) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_removegroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_removegroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_removegroup (&MyCGroup);

#endif
}

void OpenGl_GraphicDriver::TextContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {
#ifndef VIRTUAL

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_textcontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_textcontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_textcontextgroup (&MyCGroup, int (NoInsert));

#endif
}
