/***********************************************************************

FONCTION :
----------
	file OpenGl_togl_begin_layer_mode.c :

REMARQUES:
----------

HISTORIQUE DES MODIFICATIONS   :
--------------------------------
	01-12-98 : CAL ; Creation. S4062. Ajout des layers.
       02.14.100 : JR : Warnings on WNT truncations from double to float

************************************************************************/

/*----------------------------------------------------------------------*/
/*
* Includes
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H) || defined(WNT)
#include <malloc.h>
#endif

#include <OpenGl_tgl_all.h>

#include <math.h>
#include <GL/gl.h>
#include <stdio.h>

#include <InterfaceGraphic_Cextern.hxx>

#include <InterfaceGraphic_Labels.hxx>
#include <InterfaceGraphic_Graphic3d.hxx>
#include <InterfaceGraphic_Visual3d.hxx>

#include <OpenGl_tsm_ws.h>
#include <OpenGl_txgl.h>
#include <OpenGl_tXfm.h>
#include <OpenGl_tgl_tox.h>
#include <OpenGl_tgl_funcs.h>
#include <OpenGl_telem_filters.h>
#include <OpenGl_telem.h>
#include <OpenGl_telem_util.h>
#include <OpenGl_telem_view.h>

/*OCC6247*/
#include <OpenGl_telem_attri.h>
#include <OpenGl_LightBox.h>

#ifndef OCC2934 
#define OCC2934         /*SAN Texture-mapped fonts on WNT */
#endif

#ifndef OCC7667
#define OCC7667 /* ASL - Export view content to vector format file */
#endif

/*----------------------------------------------------------------------*/
/*
* Constantes
*/

#define NO_PRINT
#define NO_TRACE
#define NO_DEBUG
#define NO_TRACE_MAT
#define NO_TRACE_TEXT

#define IsNotModified 0
#define IsModified 1

/*----------------------------------------------------------------------*/
/*
* Variables externes
*/

extern GLuint linestyleBase;
extern GLuint fontBase;
#ifndef WNT
extern txfmfonthandle current_fonthandle;
#endif
/*----------------------------------------------------------------------*/
/*
* Prototypes fonctions
*/

typedef struct {
GLuint listIndex;
} CALL_DEF_PTRLAYER, *call_def_ptrLayer;

/*----------------------------------------------------------------------*/
/*
* Prototypes Private functions
*/

/*----------------------------------------------------------------------*/
/*
* Variables statiques
*/

static CALL_DEF_LAYER ACLayer;

static GLboolean layerOpen = GL_FALSE;
static float layerHeight = -1.;
static float layerWidth = -1.;
static int layerPoints = 0;
static int layerFont = -1;
static int layerType = -1;
static int layerFontFlag = IsModified;
static int layerFontType = 0;
static Tchar *layerFontId;
static float layerRed = -1.;
static float layerGreen = -1.;
static float layerBlue = -1.;
static float layerFontRed = -1.;
static float layerFontGreen = -1.;
static float layerFontBlue = -1.;

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_layer2d
(
	CALL_DEF_LAYER * alayer
)
{
call_def_ptrLayer ptrLayer;

#ifdef PRINT
	printf ("call_togl_layer2d\n");
#endif
	alayer->ptrLayer = ptrLayer =
		(call_def_ptrLayer) malloc (sizeof (CALL_DEF_PTRLAYER));

	if (ptrLayer == NULL) return;

	/*
	 * On cree la display-list associee au layer.
	 */
	ptrLayer->listIndex = glGenLists (1);
	alayer->ptrLayer = (void *) ptrLayer;
	ACLayer = *alayer;
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_removelayer2d
(
	CALL_DEF_LAYER * alayer
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) alayer->ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_removelayer2d %d\n", ptrLayer->listIndex);
#endif

	/*
	 * On detruit la display-list associee au layer.
	 */
	glDeleteLists (ptrLayer->listIndex, 1);
	ptrLayer->listIndex = 0;
	alayer->ptrLayer = (void *) ptrLayer;
	ACLayer = *alayer;
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_clear_layer2d (
	CALL_DEF_LAYER * alayer
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) alayer->ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_clear_layer2d %d\n", ptrLayer->listIndex);
#endif

	/*
	 * On clear la display-list associee au layer.
	 */
	/*
	 * On detruit la display-list associee au layer.
	 */
	glDeleteLists (ptrLayer->listIndex, 1);
	ptrLayer->listIndex = 0;
	/*
	 * On cree la display-list associee au layer.
	 */
	ptrLayer->listIndex = glGenLists (1);
	alayer->ptrLayer = (void *) ptrLayer;
	ACLayer = *alayer;
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_redraw_layer2d (
	CALL_DEF_VIEW * aview,
	CALL_DEF_LAYER * alayer
)
{
/*GLboolean flag_zbuffer = GL_FALSE;*/
call_def_ptrLayer ptrLayer;
float left, right, bottom, top;
float delta, ratio;
int attach;
#ifdef TRACE_MAT
GLdouble modelMatrix[16], projMatrix[16];
GLint viewport[4];
int i, j;
#endif
GLsizei dispWidth, dispHeight;
GLboolean isl = IsLightOn(); /*OCC6247*/

	dispWidth = (GLsizei) alayer->viewport[0];
	dispHeight = (GLsizei) alayer->viewport[1];

	ptrLayer = (call_def_ptrLayer) alayer->ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_redraw_layer2d %d\n", ptrLayer->listIndex);
	printf ("\twindow size %f %f\n",
		aview->DefWindow.dx, aview->DefWindow.dy);
	printf ("\tviewport %f %f\n", (float) dispWidth, (float) dispHeight);
#endif

        if(isl) {
	  LightOff(); /*OCC6247*/
	}

	/*
	 * On positionne la projection
	 */
	glMatrixMode( GL_MODELVIEW );
	glPushMatrix ();
	glLoadIdentity ();

	glMatrixMode (GL_PROJECTION);
	glPushMatrix ();
	glLoadIdentity ();

	if (alayer->sizeDependent == 0)
		glViewport (0, 0, dispWidth, dispHeight);

	left = alayer->ortho[0],
	right = alayer->ortho[1],
	bottom = alayer->ortho[2],
	top = alayer->ortho[3];
	attach = alayer->attach;
#ifdef TRACE
	printf ("\tattach %d ortho %f %f %f %f %d\n",
		attach, left, right, bottom, top);
#endif
	if (alayer->sizeDependent == 0)
		ratio = (float) dispWidth/dispHeight;
	else
		ratio = aview->DefWindow.dx/aview->DefWindow.dy;
	if (ratio >= 1.0) { /* fenetre horizontale */
		delta = (float )((top - bottom)/2.0);
		switch (attach) {
			case 0: /* Aspect_TOC_BOTTOM_LEFT */
				top = bottom + 2*delta/ratio;
			break;
			case 1: /* Aspect_TOC_BOTTOM_RIGHT */
				top = bottom + 2*delta/ratio;
			break;
			case 2: /* Aspect_TOC_TOP_LEFT */
				bottom = top - 2*delta/ratio;
			break;
			case 3: /* Aspect_TOC_TOP_RIGHT */
				bottom = top - 2*delta/ratio;
			break;
		}
	}
	else { /* fenetre verticale */
		delta = (float )((right - left)/2.0);
		switch (attach) {
			case 0: /* Aspect_TOC_BOTTOM_LEFT */
				right = left + 2*delta*ratio;
			break;
			case 1: /* Aspect_TOC_BOTTOM_RIGHT */
				left = right - 2*delta*ratio;
			break;
			case 2: /* Aspect_TOC_TOP_LEFT */
				right = left + 2*delta*ratio;
			break;
			case 3: /* Aspect_TOC_TOP_RIGHT */
				left = right - 2*delta*ratio;
			break;
		}
	}
#ifdef TRACE
	printf ("\tratio %f new ortho %f %f %f %f\n",
		ratio, left, right, bottom, top);
#endif
	glOrtho (left, right, bottom, top, -1.0, 1.0);

#ifdef TRACE_MAT
	glGetIntegerv (GL_VIEWPORT, viewport);
	glGetDoublev (GL_MODELVIEW_MATRIX, modelMatrix);
	glGetDoublev (GL_PROJECTION_MATRIX, projMatrix);
	printf ("viewport :\n");
	printf ("\t");
	for (i = 0; i < 4; i++)
		printf ("%d ", viewport[i]);
	printf ("\n");
	printf ("modelMatrix :\n");
	for (i = 0; i < 4; i++) {
		printf ("\t");
		for (j = 0; j < 4; j++)
			printf ("%f ", modelMatrix[i*4+j]);
		printf ("\n");
	}
	printf ("projMatrix :\n");
	for (i = 0; i < 4; i++) {
		printf ("\t");
		for (j = 0; j < 4; j++)
			printf ("%f ", projMatrix[i*4+j]);
		printf ("\n");
	}
#endif

/*OCC6247 my be removed in frame of OCC6933*/
#ifndef WNT
		tXfmfindfont (call_thedisplay, layerFontId, layerHeight);
		fontBase = tXfmsetfont (1.0, 1.0);
#else
		WNTFindFont (layerFontId, layerHeight);
		fontBase = WNTSetFont (1.0F, 1.0F);
#endif  /* WNT */
/*OCC6247*/

	/*
	 * On trace la display-list associee au layer.
	 */
#ifdef TRACE
	if (glIsList (ptrLayer->listIndex))
		printf ("\t%d is a list\n", (int)ptrLayer->listIndex);
	else
		printf ("\t%d is not a list\n", (int)ptrLayer->listIndex);
#endif
	glPushAttrib (
		GL_LIGHTING_BIT | GL_LINE_BIT | GL_POLYGON_BIT |
		GL_DEPTH_BUFFER_BIT | GL_CURRENT_BIT);
		glDisable (GL_DEPTH_TEST);
		glCallList (ptrLayer->listIndex);
	glPopAttrib ();

	/*
	 * On retire la projection
	 */
	glMatrixMode (GL_PROJECTION);
	glPopMatrix ();

	glMatrixMode( GL_MODELVIEW );
	glPopMatrix ();

	/*
	 * Restauration du Viewport en cas de modification
	 */
	if (alayer->sizeDependent == 0) 
		glViewport (0, 0,
			(GLsizei) aview->DefWindow.dx,
			(GLsizei) aview->DefWindow.dy);

	glFlush ();

        if(isl) {
	  LightOn(); /*OCC6247*/
	}

}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_begin_layer2d
(
	CALL_DEF_LAYER * alayer
)
{
call_def_ptrLayer ptrLayer;
/*GLuint listIndex = 0;*/
/*int i;*/

	ACLayer = *alayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_begin_layer2d %d\n", ptrLayer->listIndex);
#endif

	glNewList (ptrLayer->listIndex, GL_COMPILE);
	layerOpen = GL_TRUE;
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_end_layer2d
(
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_end_layer2d %d\n", ptrLayer->listIndex);
#endif

	/*
	 * On ferme la display-list associee au layer.
	 */
	if (layerOpen) glEndList ();
	layerOpen = GL_FALSE;

	ACLayer.ptrLayer = NULL;
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_begin_polyline2d (
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_begin_polyline2d %d\n", ptrLayer->listIndex);
#endif

	layerPoints = 0;
	glBegin (GL_LINE_STRIP);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_end_polyline2d (
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_end_polyline2d %d\n", ptrLayer->listIndex);
#endif

	glEnd ();
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_begin_polygon2d (
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_begin_polygon2d %d\n", ptrLayer->listIndex);
#endif

	layerPoints = 0;
	glBegin (GL_POLYGON);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_end_polygon2d (
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_end_polygon2d %d\n", ptrLayer->listIndex);
#endif

	glEnd ();
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_edge2d (
	float x,
	float y
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_edge2d %d\n", ptrLayer->listIndex);
	printf ("\tcoord %f %f\n", x, y);
#endif

	layerPoints ++;
	glVertex3f (x, y, 0.);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_draw2d
(
	float x,
	float y
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_draw2d %d\n", ptrLayer->listIndex);
	printf ("\tcoord %f %f\n", x, y);
#endif

	layerPoints ++;
	glVertex3f (x, y, 0.);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_move2d
(
	float x,
	float y
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_move2d %d\n", ptrLayer->listIndex);
	printf ("\tcoord %f %f\n", x, y);
#endif

	if (layerPoints != 0) {
		call_togl_end_polyline2d ();
		call_togl_begin_polyline2d ();
	}

	layerPoints ++;
	glVertex3f (x, y, 0.);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_rectangle2d
(
	float x,
	float y,
	float w,
	float h
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_rectangle2d %d\n", ptrLayer->listIndex);
	printf ("\trectangle %f %f %f %f\n", x, y, w, h);
#endif

	glRectf (x, y, x + w, y + h);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_text2d
(
	char *s,
	float x,
	float y,
	float height
)
{
call_def_ptrLayer ptrLayer;
#ifndef WNT
  Tint dispWidth, dispHeight;
#endif
/*GLint sWidth, sAscent, sDescent;*/
/*GLdouble modelMatrix[16], projMatrix[16];*/
/*GLint viewport[4];*/
GLdouble objx1, objy1, objz1;
/*GLdouble objx2, objy2, objz2;*/
/*GLdouble objx3, objy3, objz3;*/
/*GLdouble objx4, objy4, objz4;*/
/*GLdouble objx5, objy5, objz5;*/
/*GLdouble winx1, winy1, winz1;*/
/*GLdouble winx2, winy2, winz2;*/
/*GLint status;*/
/*int i, j;*/

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef TRACE_TEXT
	printf ("call_togl_text2d %d\n", ptrLayer->listIndex);
	printf ("\ttext %s %f %f %f\n", s, x, y, height);
#endif

#ifndef WNT
	call_tox_getscreen (&dispWidth, &dispHeight);
/*	height = height * dispHeight;*/ /*OCC6247*/
        height = height * call_tox_getpitchsize(); /*OCC6247*/
#endif
#ifdef TRACE_TEXT
	printf ("layerHeight != height %s\n", (layerHeight != height ? "yes" : "no"));
	printf ("layerFontFlag == IsModified %s\n", (layerFontFlag == IsModified ? "yes" : "no"));
#endif
	if (layerHeight != height || layerFontFlag == IsModified) {
		layerFontFlag = IsNotModified;
		layerHeight = height;
#ifndef WNT
		tXfmfindfont (call_thedisplay, layerFontId, layerHeight);
		fontBase = tXfmsetfont (1.0, 1.0);
#else
		WNTFindFont (layerFontId, layerHeight);
		fontBase = WNTSetFont (1.0F, 1.0F);
#endif  /* WNT */
	}

	objx1 = x,
	objy1 = y,
	objz1 = 0.0;

	/*
	 * On traite les differents types d'affichage de texte
	 */
	switch (layerFontType) {
	case 0 : /* Aspect_TODT_Normal */
	#ifdef DEBUG
		printf ("---------------------\n");
		printf ("texte normal %f %f\n", objx1, objy1);
	#endif
/*
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f);
#else
		glRasterPos2f ((float )objx1, (float )objy1);
#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
#else
		WNTPuts (s, fontBase);
#endif
#endif
*/

#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase, (float )objx1, (float )objy1, 0.f);
#else
		WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f );
#endif


	break;
	case 1 : /* Aspect_TODT_SubTitle */
#ifdef OK
	#ifdef DEBUG
		printf ("---------------------\n");
		printf ("texte subtitle %f %f\n", objx1, objy1);
	#endif
		glGetIntegerv (GL_VIEWPORT, viewport);
		glGetDoublev (GL_MODELVIEW_MATRIX, modelMatrix);
		glGetDoublev (GL_PROJECTION_MATRIX, projMatrix);
	#ifdef TRACE_MAT
		printf ("viewport :\n");
		printf ("\t");
		for (i = 0; i < 4; i++)
			printf ("%d ", viewport[i]);
		printf ("\n");
		printf ("modelMatrix :\n");
		for (i = 0; i < 4; i++) {
			printf ("\t");
			for (j = 0; j < 4; j++)
				printf ("%f ", modelMatrix[i*4+j]);
			printf ("\n");
		}
		printf ("projMatrix :\n");
		for (i = 0; i < 4; i++) {
			printf ("\t");
			for (j = 0; j < 4; j++)
				printf ("%f ", projMatrix[i*4+j]);
			printf ("\n");
		}
	#endif
        /*
	 * dimensionString("Methode cadre", &sWidth, &sAscent, &sDescent);
	 */
sWidth = 2.;
sAscent = .2;
sDescent = .2;

		objx2 = objx1; objy2 = objy1; objz2 = objz1;
		objx3 = objx1; objy3 = objy1; objz3 = objz1;
		objx4 = objx1; objy4 = objy1; objz4 = objz1;
		objx5 = objx1; objy5 = objy1; objz5 = objz1;

		status = gluProject (objx1, objy1, objz1,
				modelMatrix, projMatrix, viewport,
				&winx1, &winy1, &winz1);

		winx2 = winx1;
		winy2 = winy1-sDescent;
		winz2 = winz1+0.00001;
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx2, &objy2, &objz2);

		winx2 = winx1 + sWidth;
		winy2 = winy1-sDescent;
		winz2 = winz1+0.00001; /* il vaut mieux F+B / 1000000 ? */
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx3, &objy3, &objz3);

		winx2 = winx1 + sWidth;
		winy2 = winy1 + sAscent;
		winz2 = winz1+0.00001;
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx4, &objy4, &objz4);

		winx2 = winx1;
		winy2 = winy1+ sAscent;
		winz2 = winz1+0.00001;
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx5, &objy5, &objz5);

		glColor3f (layerFontRed, layerFontGreen, layerFontBlue);
		glBegin(GL_POLYGON);
			glVertex3d(objx2, objy2, objz2);
			glVertex3d(objx3, objy3, objz3);
			glVertex3d(objx4, objy4, objz4);
			glVertex3d(objx5, objy5, objz5);
		glEnd();
		glColor3f (layerRed, layerGreen, layerBlue);
#endif /* OK */

/*
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f);
#else
		glRasterPos2f ((float )objx1, (float )objy1);
#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
#else
		WNTPuts (s, fontBase);
#endif
#endif
*/
#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase, (float )objx1, (float )objy1, 0.f);
#else
		WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f);
#endif

	break;
	case 2 : /* Aspect_TODT_Dekale */
#ifdef OK
	#ifdef DEBUG
		printf ("---------------------\n");
		printf ("texte dekale %f %f\n", objx1, objy1);
	#endif
		glGetIntegerv (GL_VIEWPORT, viewport);
		glGetDoublev (GL_MODELVIEW_MATRIX, modelMatrix);
		glGetDoublev (GL_PROJECTION_MATRIX, projMatrix);
	#ifdef DEBUG
		printf ("viewport :\n");
		printf ("\t");
		for (i = 0; i < 4; i++)
			printf ("%d ", viewport[i]);
		printf ("\n");
		printf ("modelMatrix :\n");
		for (i = 0; i < 4; i++) {
			printf ("\t");
			for (j = 0; j < 4; j++)
				printf ("%f ", modelMatrix[i*4+j]);
			printf ("\n");
		}
		printf ("projMatrix :\n");
		for (i = 0; i < 4; i++) {
			printf ("\t");
			for (j = 0; j < 4; j++)
				printf ("%f ", projMatrix[i*4+j]);
			printf ("\n");
		}
	#endif
		status = gluProject (objx1, objy1, objz1,
				modelMatrix, projMatrix, viewport,
				&winx1, &winy1, &winz1);
	#ifdef DEBUG
		printf ("status %s\n", (status == GL_FALSE ? "ko" : "ok"));
	#endif
		winx2 = winx1+1;
		winy2 = winy1+1;
		winz2 = winz1+0.00001;
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx2, &objy2, &objz2);
	#ifdef DEBUG
		printf ("status %s\n", (status == GL_FALSE ? "ko" : "ok"));
	#endif
		glColor3f (layerFontRed, layerFontGreen, layerFontBlue);
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, objx2, objy2, 0.f);
#else
		glRasterPos2f (objx2, objy2);
	#ifdef DEBUG
		printf ("texte dekale %f %f\n", objx2, objy2);
	#endif
	#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
	#else
		WNTPuts (s, fontBase);
	#endif
#endif
		winx2 = winx1-1;
		winy2 = winy1-1;
		winz2 = winz1+0.00001;
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx2, &objy2, &objz2);
	#ifdef DEBUG
		printf ("status %s\n", (status == GL_FALSE ? "ko" : "ok"));
	#endif
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, objx2, objy2, 0.f);
#else
		glRasterPos2f (objx2, objy2);
	#ifdef DEBUG
		printf ("texte dekale %f %f\n", objx2, objy2);
	#endif
	#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
	#else
		WNTPuts (s, fontBase);
	#endif
#endif
		winx2 = winx1-1;
		winy2 = winy1+1;
		winz2 = winz1+0.00001;
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx2, &objy2, &objz2);
	#ifdef DEBUG
		printf ("status %s\n", (status == GL_FALSE ? "ko" : "ok"));
	#endif
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, objx2, objy2, 0.f);
#else
		glRasterPos2f (objx2, objy2);
	#ifdef DEBUG
		printf ("texte dekale %f %f\n", objx2, objy2);
	#endif
	#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
	#else
		WNTPuts (s, fontBase);
	#endif
#endif
		winx2 = winx1+1;
		winy2 = winy1-1;
		winz2 = winz1+0.00001;
		status = gluUnProject (winx2, winy2, winz2,
				modelMatrix, projMatrix, viewport,
				&objx2, &objy2, &objz2);
	#ifdef DEBUG
		printf ("status %s\n", (status == GL_FALSE ? "ko" : "ok"));
	#endif
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, objx2, objy2, 0.f);
#else
		glRasterPos2f (objx2, objy2);
	#ifdef DEBUG
		printf ("texte dekale %f %f\n", objx2, objy2);
	#endif
	#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
	#else
		WNTPuts (s, fontBase);
	#endif
#endif
		glColor3f (layerRed, layerGreen, layerBlue);
#endif /* OK */
/*
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f);
#else
		glRasterPos2f ((float )objx1, (float )objy1);
#ifdef DEBUG
		printf ("texte dekale %f %f\n", objx1, objy1);
#endif
#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
#else
		WNTPuts (s, fontBase);
#endif
#endif
*/
#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase, (float )objx1, (float )objy1, 0.f);
#else
		WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f);
#endif

#ifdef DEBUG
		printf ("---------------------\n");
#endif
	break;
	case 3 : /* Aspect_TODT_Blend */
#ifdef OK
	#ifndef WNT
		glEnable (GL_BLEND);
		glBlendEquationEXT (GL_LOGIC_OP);
		glLogicOp (GL_XOR);
		glColor3f (layerRed, layerGreen, layerBlue);
		glRasterPos2f (objx1, objy1);
		tXfmprstr ((unsigned char *)s, fontBase);
		glDisable (GL_BLEND);
	#else
		glColor3f (layerRed, layerGreen, layerBlue);
#if defined(OCC2934)
                WNTPuts (s, fontBase, 1, objx1, objy1, 0.f);
#else
		glRasterPos2f (objx1, objy1);
		WNTPuts (s, fontBase);
#endif
	#endif

#else /* OK */
	#ifdef DEBUG
		printf ("---------------------\n");
		printf ("texte blend %f %f\n", objx1, objy1);
	#endif
/*
#if defined(OCC2934) && defined(WNT)
                WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f);
#else
		glRasterPos2f ((float )objx1, (float )objy1);
	#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase);
	#else
		WNTPuts (s, fontBase);
	#endif
#endif
*/
	#ifndef WNT
		tXfmprstr ((unsigned char *)s, fontBase, (float )objx1, (float )objy1, 0.f);
	#else
		WNTPuts (s, fontBase, 1, (float )objx1, (float )objy1, 0.f);
	#endif

	#ifdef DEBUG
		printf ("---------------------\n");
	#endif
#endif /* OK */
	break;
	}
}

void EXPORT
call_togl_textsize2d
(
	char *s,
	float height,
	float *width,
	float *ascent,
	float *descent
)
{
  call_def_ptrLayer ptrLayer;
#ifndef WNT
  Tint dispWidth, dispHeight;
#endif
  GLint Width;
  GLint Ascent;
  GLint Descent;

  *width = 0.;
  *ascent = 0.;
  *descent = 0.;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;

#ifndef WNT
	call_tox_getscreen (&dispWidth, &dispHeight);
/*	height = height * dispHeight;*/ /*OCC6247*/
        height = height * call_tox_getpitchsize(); /*OCC6247*/
#endif
	if (layerHeight != height || layerFontFlag == IsModified) {
		layerFontFlag = IsNotModified;
		layerHeight = height;
#ifndef WNT
		tXfmfindfont (call_thedisplay, layerFontId, layerHeight);
		fontBase = tXfmsetfont (1.0, 1.0);
#else
		WNTFindFont (layerFontId, layerHeight);
		fontBase = WNTSetFont (1.0F, 1.0F);
#endif  /* WNT */
	}
  sizeString(s, &Width, &Ascent, &Descent);
  *width = (float) Width;
  *ascent = (float) Ascent;
  *descent = (float) Descent;

#ifndef WNT
  current_fonthandle->dirty=1;
#endif
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_set_color
(
	float r,
	float g,
	float b
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_set_color %d\n", ptrLayer->listIndex);
	printf ("\tcolor %f %f %f\n", r, g, b);
#endif

	layerRed = r,
	layerGreen = g,
	layerBlue = b;
	glColor3f (r, g, b);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_set_transparency
(
	float a
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_set_transparency %d\n", ptrLayer->listIndex);
	printf ("\ttransparency %f\n", a);
#endif

  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f (layerRed, layerGreen, layerBlue, a);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_unset_transparency
(
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_set_untransparency %d\n", ptrLayer->listIndex);
#endif

  glDisable (GL_BLEND);
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_set_line_attributes
(
	long type,
	float width
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_set_line_attributes %d\n", ptrLayer->listIndex);
	printf ("\ttype, width %d %f\n", type, width);
#endif
	if (layerType != type) {
	    layerType = type;
	    if (layerType == 0) { /* TOL_SOLID */
		glDisable (GL_LINE_STIPPLE);
	    }
	    else {
		if (layerType) {
		    glCallList (linestyleBase+layerType);
		    glEnable (GL_LINE_STIPPLE);
		}
	    }
	}
	if (layerWidth != width) {
		layerWidth = width;
		glLineWidth ((GLfloat) layerWidth);
	}
}

/*----------------------------------------------------------------------*/
void EXPORT
call_togl_set_text_attributes
(
	long font,
	long type,
	float r,
	float g,
	float b
)
{
call_def_ptrLayer ptrLayer;

	ptrLayer = (call_def_ptrLayer) ACLayer.ptrLayer;
	if (ptrLayer == NULL) return;
	if (ptrLayer->listIndex == 0) return;
#ifdef PRINT
	printf ("call_togl_set_text_attributes %d\n", ptrLayer->listIndex);
	printf ("\tfont %ld type %ld\n", font, type);
	printf ("\tcolor %f %f %f\n", r, g, b);
#endif

	/*
	 * On sauvegarde les valeurs pour les utiliser dans call_togl_text2d
	 */
	layerFontType = type;
	layerFontRed = r;
	layerFontGreen = g;
	layerFontBlue = b;

	/*
	 * On gere le type de font (ASCII !)
	 */
	if (layerFont == font) return;
	layerFont = font;
	layerFontFlag = IsModified;

	switch (font) {
	case 0 : /* Graphic3d_NOF_ASCII_MONO */
		layerFontId = CALL_PHIGS_ASCII_MONO;
	break;
	case 1 : /* Graphic3d_NOF_ASCII_SIMPLEX */
		layerFontId = CALL_PHIGS_ASCII_SIMPLEX;
	break;
	case 2 : /* Graphic3d_NOF_ASCII_DUPLEX */
		layerFontId = CALL_PHIGS_ASCII_DUPLEX;
	break;
	case 3 : /* Graphic3d_NOF_ASCII_COMPLEX */
		layerFontId = CALL_PHIGS_ASCII_COMPLEX;
	break;
	case 4 : /* Graphic3d_NOF_ASCII_TRIPLEX */
		layerFontId = CALL_PHIGS_ASCII_TRIPLEX;
	break;
	case 5 : /* Graphic3d_NOF_ASCII_ITALIC_COMPLEX */
		layerFontId = CALL_PHIGS_ASCII_ITALIC_COMPLEX;
	break;
	case 6 : /* Graphic3d_NOF_ASCII_ITALIC_TRIPLEX */
		layerFontId = CALL_PHIGS_ASCII_ITALIC_TRIPLEX;
	break;
	case 7 : /* Graphic3d_NOF_ASCII_SCRIPT_SIMPLEX */
		layerFontId = CALL_PHIGS_ASCII_SCRIPT_SIMPLEX;
	break;
	case 8 : /* Graphic3d_NOF_GREEK_MONO */
		layerFontId = CALL_PHIGS_GREEK_MONO;
	break;
	case 9 : /* Graphic3d_NOF_GREEK_SIMPLEX */
		layerFontId = CALL_PHIGS_GREEK_SIMPLEX;
	break;
	case 10 : /* Graphic3d_NOF_GREEK_COMPLEX */
		layerFontId = CALL_PHIGS_GREEK_COMPLEX;
	break;
	case 11 : /* Graphic3d_NOF_SYMBOL_MONO */
		layerFontId = CALL_PHIGS_SYMBOL_MONO;
	break;
	case 12 : /* Graphic3d_NOF_SYMBOL_SIMPLEX */
		layerFontId = CALL_PHIGS_SYMBOL_SIMPLEX;
	break;
	case 13 : /* Graphic3d_NOF_CARTOGRAPHIC_SIMPLEX */
		layerFontId = CALL_PHIGS_CARTOGRAPHIC_SIMPLEX;
	break;
	case 14 : /* Graphic3d_NOF_KANJI_MONO */
		layerFontId = CALL_PHIGS_KANJI_MONO;
	break;
	case 15 : /* Graphic3d_NOF_KATAKANA_MONO */
		layerFontId = CALL_PHIGS_KATAKANA_MONO;
	break;
	default :
		layerFontId = CALL_PHIGS_ASCII_MONO;
	break;
	}
}
