// File:	StepToGeom_MakeDirection2d.cxx
// Created:	Wed Aug  4 11:50:31 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 23.10.2001. CTS23496: Direction is not created if it has null magnitude (StepToGeom_MakeDirection2d(...) function)

#include <StepToGeom_MakeDirection2d.ixx>
#include <StepGeom_Direction.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Direction de Geom2d a partir d' un Direction de Step
//=============================================================================

StepToGeom_MakeDirection2d::StepToGeom_MakeDirection2d
  ( const Handle(StepGeom_Direction)& D)
{
  if (D->NbDirectionRatios() != 2 ) {
    if (D->NbDirectionRatios() == 1) {
      done = Standard_False;
      return;
    }
    else {
#ifdef DEBUG
      cout << "Warning : Direction in UV is given with 3 coordinates" << endl;
#endif
    }
  }
  Standard_Real X = D->DirectionRatiosValue(1);
  Standard_Real Y = D->DirectionRatiosValue(2);
  // sln 23.10.2001. CTS23496: Direction is not created if it has null magnitude
  gp_XY aXY(X, Y);
  Standard_Real aTol = gp::Resolution()*gp::Resolution();
  Standard_Real aMagnitude = aXY.SquareModulus();
  if(aMagnitude > aTol) {
    theDirection = new Geom2d_Direction(X, Y);
    done = Standard_True;
  }
  else done = Standard_False;   
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_Direction) &
      StepToGeom_MakeDirection2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theDirection;
}
