// 2DDisplayDoc.cpp : implementation of the C2DDisplayDoc class
//

#include "stdafx.h"

#include "2DDisplayDoc.h"

#include "2DDisplayApp.h"
#include "Aspect_ColorMap.hxx"
#include "Aspect_MarkMapEntry.hxx"
#include "Primitive\Sample2D_Markers.h"
#include "Primitive\Sample2D_Line.h"
#include "Primitive\Sample2D_Text.h"

/////////////////////////////////////////////////////////////////////////////
// C2DDisplayDoc

IMPLEMENT_DYNCREATE(C2DDisplayDoc, CDocument)

BEGIN_MESSAGE_MAP(C2DDisplayDoc, CDocument)
	//{{AFX_MSG_MAP(C2DDisplayDoc)
	ON_COMMAND(ID_BUTTON_Test_Text, OnBUTTONTestText)
 	ON_COMMAND(ID_BUTTON_Test_Markers, OnBUTTONTestMarkers)
	ON_COMMAND(ID_BUTTON_Test_Line, OnBUTTONTestLine)
	ON_COMMAND(ID_BUTTON_Erase, OnBUTTONErase)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C2DDisplayDoc construction/destruction

C2DDisplayDoc::C2DDisplayDoc()
{
}

C2DDisplayDoc::~C2DDisplayDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// C2DDisplayDoc diagnostics

#ifdef _DEBUG
void C2DDisplayDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void C2DDisplayDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// C2DDisplayDoc commands

void C2DDisplayDoc::OnBUTTONErase() 
{
   myAISInteractiveContext2D->EraseAll();
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Erase;
  TCollection_AsciiString Message("\
call :    \n\
   myAISInteractiveContext2D->EraseAll();\n\
--------------------------------------------------------------------------------");
  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}



void C2DDisplayDoc::OnBUTTONTestText() 
{
//#define SAV
#ifdef SAV
	Handle(AIS2D_InteractiveObject) obj1 = new AIS2D_InteractiveObject();
	Handle(Graphic2d_Text) text = new Graphic2d_Text( obj1, TCollection_ExtendedString( "SAV_GR2D" ),
													  50.0, 0.0, 0.07, Aspect_TOT_SOLID, 0.009/*0.000777693*/ );
/*
	Create (aGraphicObject: GraphicObject from Graphic2d;
		aText: ExtendedString from TCollection;
		X, Y: Real from Standard;
		anAngle: PlaneAngle from Quantity = 0.0;
		aType: TypeOfText from Aspect = Aspect_TOT_SOLID;
		aScale: Factor from Quantity = 1.0)
*/

	//0.000777693
	text->SetZoomable( Standard_False );
	//TCollection_AsciiString aText( "SAV_SAMPLE" );
	//Handle(Sample2D_Text) obj2 = new Sample2D_Text( aText );
	myAISInteractiveContext2D->Display( obj1 );
	//myAISInteractiveContext2D->Display( obj2 );
#endif
#define OLD_CODE
#ifdef OLD_CODE
 Standard_Integer color=1;
 for (Standard_Real j=15;j<=20;j++)
  {
    TCollection_AsciiString Text("font 0 scale ");Text+=j/20;
    Handle (Sample2D_Text) aText  = new Sample2D_Text(
		               Text,             //Text to output
                       0,15*(j-15),      //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       20.0*PI180 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,               //  aColorIndex  
                       0,               //  aFontIndex  
                       j/20,                //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_True/*False*/,   // aIsZoomable
                       Graphic2d_TOA_LEFT); // aTypeOfAlignment

     myAISInteractiveContext2D->Display(aText,            // object
                                        Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
  for (j=5;j<=10;j+=1)
  {
    TCollection_AsciiString Text("font 1 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText = new Sample2D_Text(
					   Text,         //Text to output
                       80,15*(j-5),  //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0.0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,         //  aColorIndex  
                       1,               //  aFontIndex  
                       j/10,                //  aScale 
                       Standard_True,  // aIsUnderline
                       Standard_True,   // aIsZoomable
                       Graphic2d_TOA_CENTER); // aTypeOfAlignment

     myAISInteractiveContext2D->Display(aText,            // object
                                       Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
    
  for (j=5;j<=10;j+=1)
  {
    TCollection_AsciiString Text("font 2 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText = new Sample2D_Text(
		               Text,          //Text to output
                       140,15*(j-5),  //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0.0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,         //  aColorIndex  
                       2,               //  aFontIndex  
                       j/10,               //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_True,   // aIsZoomable
                       Graphic2d_TOA_TOPLEFT); // aTypeOfAlignment


    myAISInteractiveContext2D->Display(aText,            // object
                                       Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
    
  for (j=10;j<=15;j+=1)
  {
    TCollection_AsciiString Text("font 3 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText = new Sample2D_Text(
		               Text,               //Text to output
                       260,15*(j-10),      //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,               //  aColorIndex  
                       3,               //  aFontIndex  
                       j/10,                //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_True/*False*/,   // aIsZoomable
                       Graphic2d_TOA_LEFT); // aTypeOfAlignment


    myAISInteractiveContext2D->Display(aText,            // object
                                       Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
  FitAll2DViews(Standard_True); // Update Viewer
#endif //OLD_CODE
  // Update Get information to update Result dialog
  UINT anID=ID_BUTTON_Test_Text;
  TCollection_AsciiString Message("  \
create a set of Sample2D_Text and display it :    \n\
------------------------------------------------------------------------------ \n\
    Handle (Sample2D_Text) aText;                          \n\
    // aText = new ...                                            \n\
   myAISInteractiveContext2D->Display(aText);  // Display       \n\
------------------------------------------------------------------------------ \n\
   after that the system call the SetContext Method :                    \n\
------------------------------------------------------------------------------ \n\
                                                                  \n\
void Sample2D_Text::SetContext(const Handle(AIS2D_InteractiveContext)& theContext) \n\
{ \n\
  AIS2D_InteractiveObject::SetContext(theContext); \n\
\n\
  Handle(Graphic2d_Text) text;            \n\
  text = new Graphic2d_Text(this, myText,        \n\
                                               myX, myY,  \n\
                                               myAngle,myTypeOfText, \n\
                                               myScale);\n\
  text->SetFontIndex  (myFontIndex);\n\
  text->SetColorIndex (myColorIndex);\n\
  text->SetSlant         (mySlant);\n\
  text->SetUnderline   (myIsUnderline);\n\
  text->SetZoomable  (myIsZoomable);\n\
  text->SetAlignment  (myTypeOfAlignment);\n\
}\n\
\n");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);

}


void C2DDisplayDoc::OnBUTTONTestMarkers() 
{
    {    // generic Markers
      Standard_Integer MaxIndex = my2DViewer->MarkMap()->Size();
      
	  for (int i=1;i<=MaxIndex;i++)
      {
        Standard_Integer EntryNumber =  (my2DViewer->MarkMap()->Entry(i)).Index () ;

        Handle(Sample2D_Markers) Marker  = new Sample2D_Markers(
			                   EntryNumber, // generic marker index
                               10*i,0,// display point
                               5,5, // size
                               0); // angle in radian
        myAISInteractiveContext2D->Display(Marker);  // Display marker

      }
      for (i=1;i<=MaxIndex;i++)
      {
        Standard_Integer EntryNumber =  (my2DViewer->MarkMap()->Entry(i)).Index () ;
        Handle (Sample2D_Markers) Marker  = new Sample2D_Markers(
			                     EntryNumber, // generic marker index
                                 10*i,10,// display point
                                 5,5, // size
                                 20*PI180); // angle in radian
        myAISInteractiveContext2D->Display(Marker);  // Display marker
      }
    }

    
    {  // a Circle Marker 
      Handle (Sample2D_Markers) Marker  = new Sample2D_Markers(
							   10,20,// reference point
                               0,0, // display point
                               2); // radius
      myAISInteractiveContext2D->Display(Marker);  // Display marker
    }
    
    {  // an ellips Marker 
      Handle (Sample2D_Markers) Marker  = new Sample2D_Markers(
		                       20,20, // reference point
                               0,0,  // display point
                               3,2,    // major, minor radius
                               20*PI180); // angle

	  myAISInteractiveContext2D->Display(Marker);  // Display marker
    }

    {  // a polyline  Marker 

      Graphic2d_Array1OfVertex myListVertex(1,6);
      myListVertex(1)=Graphic2d_Vertex(0.,0.);
      myListVertex(2)=Graphic2d_Vertex(0.,5.);
      myListVertex(3)=Graphic2d_Vertex(10.,0.);
      myListVertex(4)=Graphic2d_Vertex(10.,5.);
      myListVertex(5)=Graphic2d_Vertex(20.,0.);
      myListVertex(6)=Graphic2d_Vertex(20.,5.);

      Handle (Sample2D_Markers) Marker  = new Sample2D_Markers(
							   30,20, // reference point
                               myListVertex); 

	  myAISInteractiveContext2D->Display(Marker);  // Display marker
    }

  FitAll2DViews(Standard_False); // Update Viewer
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_Markers;
  TCollection_AsciiString Message(" \
create a set of Sample2D_Markers and display it :\n\
---------------------------------------------------\n\
    {\n\
      Standard_Integer MaxIndex = my2DViewer->MarkMap()->Size();\n\
      for (int i=1;i<=MaxIndex;i++) {\n\
        Standard_Integer EntryNumber =  (my2DViewer->MarkMap()->Entry(10)).Index () ;\n\
        Handle (Sample2D_Markers) Marker  = new Sample2D_Markers( \n\
		                         EntryNumber, // generic marker index\n\
                                 10*i,0,// display point\n\
                                 5,5, // size\n\
                                 0); // angle in radian\n\
        myAISInteractiveContext2D->Display(Marker); // Display marker\n\
    }\n\
  //...\n\
\n\
   after that the system call the SetContext Methods :                    \n\
\n\
void Sample2D_Markers::SetContext(const Handle(AIS2D_InteractiveContext)& theContext) \n\
{ \n\
    AIS2D_InteractiveObject::SetContext(theContext); \n\
\n\
    if (myCurrentTypeOfMarker == 2D_CTOM_Generic) \n\
      if ( myIndex == 0 ) {\n\
        Handle(Graphic2d_Marker) aMarker=  \n\
        new Graphic2d_Marker(this, \n\
        myXPosition ,myYPosition); \n\
      }\n\
    else {\n\
       Handle(Graphic2d_Marker) aMarker=  \n\
        new Graphic2d_Marker(thsi,myIndex, \n\
        myXPosition ,myYPosition, \n\
        myWidth,myHeight,myAngle); \n\
   }\n\
 \n\
    if (myCurrentTypeOfMarker == 2D_CTOM_Polyline) \n\
      Handle(Graphic2d_PolylineMarker) aMarker=  \n\
      new Graphic2d_PolylineMarker(this, \n\
      myXPosition,myYPosition, \n\
      myListVertex); \n\
 \n\
    if (myCurrentTypeOfMarker == 2D_CTOM_Circle) \n\
      Handle(Graphic2d_CircleMarker) aMarker=  \n\
      new Graphic2d_CircleMarker(this, \n\
      myXPosition,myYPosition, \n\
      myX ,myY,myRadius  ); \n\
 \n\
    if (myCurrentTypeOfMarker == 2D_CTOM_Ellips) \n\
      Handle(Graphic2d_EllipsMarker) aMarker=  \n\
      new Graphic2d_EllipsMarker(this, \n\
      myXPosition,myYPosition, \n\
      myX,myY, \n\
      myMajorRadius,myMinorRadius, \n\
      myAngle ); \n\
 \n\
} \n\n");
  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}

void C2DDisplayDoc::OnBUTTONTestLine() 
{

  //Create an interactive object that will hold polyline primitives
  Handle(Sample2D_Line) aLines = new Sample2D_Line;

  myAISInteractiveContext2D->Display(aLines);

  FitAll2DViews(Standard_False); // Update Viewer
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_Line;
  TCollection_AsciiString Message(" \
create a new Sample2D_Line:    \n\
     Handle(Sample2D_Line) aLines = new Sample2D_Line;\n\
\n\
 display the InteractiveObject and update the views \n\
     myAISInteractiveContext2D->Display(aLinest);\n\
     FitAll2DViews(Standard_False);\n\
--------------------------------------------------------------------------------------- \n\
 after that the system call SetContext method: \n\
\n\
void Sample2D_Line::SetContext(const Handle(AIS2D_InteractiveContext)& theContext) \n\
{\n\
     AIS2D_InteractiveObject::SetContext(theContext); \n\
\n\
     //create a new aspect for lines and set a type of lines as Graphic2d_TOPF_FILLED \n\
     Handle(Prs2d_AspectLine) aLineAspect = new Prs2d_AspectLine;  \n\
     aLineAspect->SetTypeOfFill(Graphic2d_TOPF_FILLED); \n\
\n\
     for (int i=0;i<=10;i++)  \n\
       for (int j=1;j<=4;j++) \n\
       {\n\
            Graphic2d_Array1OfVertex anArrayVertex(1,5); \n\
            anArrayVertex(1)=Graphic2d_Vertex(20.*i,10.*j+0); \n\
            anArrayVertex(2)=Graphic2d_Vertex(20.*i+10,10.*j+0); \n\
            anArrayVertex(3)=Graphic2d_Vertex(20.*i+10,10.*j+5); \n\
            anArrayVertex(4)=Graphic2d_Vertex(20.*i,10.*j+5); \n\
            anArrayVertex(5)=Graphic2d_Vertex(20.*i,10.*j+0); \n\
            Handle(Graphic2d_Polyline) aPolyline = new Graphic2d_Polyline(this, anArrayVertex); \n\
\n\
            //set the line aspect for a polyline and its internal color \n\
            SetAspect(aLineAspect, aPolyline); \n\
            aPolyline->SetInteriorColorIndex(i); \n\
            aPolyline->SetTypeIndex(j); \n\
       } \n\
} \n\
---------------------------------------------------------------------------------------");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}




