// 2DFaceDoc.cpp : implementation of the C2DFaceDoc class
//

#include "stdafx.h"

#include "2DFaceDoc.h"

#include "2DFaceApp.h"

#include "BRepTools.hxx"
#include "BRep_Builder.hxx"
#include "Aspect_ColorMapEntry.hxx"
#include "TopoDS.hxx"
#include <Primitive\Sample2D_Face.h>
#include "Properties\PropertiesSheet.h"

/////////////////////////////////////////////////////////////////////////////
// C2DFaceDoc

IMPLEMENT_DYNCREATE(C2DFaceDoc, CDocument)

BEGIN_MESSAGE_MAP(C2DFaceDoc, CDocument)
	//{{AFX_MSG_MAP(C2DFaceDoc)
	ON_COMMAND(ID_MENU_CASCADE_PROPERTIES, OnBUTTONTest2DProperties)
	ON_COMMAND(ID_BUTTON_Test_Face, OnBUTTONTestFace)
	ON_COMMAND(ID_BUTTON_Erase, OnBUTTONErase)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C2DFaceDoc construction/destruction

C2DFaceDoc::C2DFaceDoc()
{
}

C2DFaceDoc::~C2DFaceDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// C2DFaceDoc diagnostics

#ifdef _DEBUG
void C2DFaceDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void C2DFaceDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// C2DFaceDoc commands

void C2DFaceDoc::OnBUTTONTest2DProperties() 
{
	// TODO: Add your command handler code here
  CPropertiesSheet aDial;
  aDial.SetViewer(my2DViewer);
  aDial.DoModal();
}

void C2DFaceDoc::OnBUTTONErase() 
{
   myAISInteractiveContext2D->EraseAll();
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Erase;
  TCollection_AsciiString Message("\
call :    \n\
   myAISInteractiveContext2D->EraseAll(); ");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}

void C2DFaceDoc::OnBUTTONTestFace() 
{
  myAISInteractiveContext2D->EraseAll();
  CFileDialog dlg(TRUE,
                  NULL,
                  NULL,
                  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
                  "BRep Files (*.brep)|*.brep; ||", 
                  NULL );

  CString initdir(((OCC_BaseApp*) AfxGetApp())->GetInitDataDir());
  initdir += "\\Data";

  dlg.m_ofn.lpstrInitialDir = initdir;

  if (dlg.DoModal() == IDOK) 
  {
    SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
    CString filename = dlg.GetPathName();
    Standard_CString aFileName = (Standard_CString)(LPCTSTR)filename;

    TopoDS_Shape aFace;
	BRep_Builder aBuilder;
	Standard_Boolean result = BRepTools::Read(aFace,aFileName,aBuilder);

	if(aFace.IsNull() || aFace.ShapeType() != TopAbs_FACE) {
		AfxMessageBox("The shape must be not a null Face");
		return;
	}

//	Handle(ISessionSample2D_Face) aDisplayableFace = new ISessionSample2D_Face( TopoDS::Face(aFace)  );
	Handle(Sample2D_Face) aDisplayableFace = new Sample2D_Face( TopoDS::Face(aFace)  );

    myAISInteractiveContext2D->Display(aDisplayableFace,  // object
                                       Standard_True);     // Redraw

    Handle(Aspect_ColorMap) aColorMap = my2DViewer->ColorMap();
    Aspect_ColorMapEntry aFORWARDColorMapEntry  = aColorMap->FindEntry(aDisplayableFace->FORWARDColorIndex());
    Aspect_ColorMapEntry aREVERSEDColorMapEntry = aColorMap->FindEntry(aDisplayableFace->REVERSEDColorIndex());
    Aspect_ColorMapEntry aINTERNALColorMapEntry = aColorMap->FindEntry(aDisplayableFace->INTERNALColorIndex());
    Aspect_ColorMapEntry aEXTERNALColorMapEntry = aColorMap->FindEntry(aDisplayableFace->EXTERNALColorIndex());

    Quantity_Color TheFORWARDColor  =  aFORWARDColorMapEntry.Color();
    Quantity_Color TheREVERSEDColor =  aREVERSEDColorMapEntry.Color();
    Quantity_Color TheINTERNALColor =  aINTERNALColorMapEntry.Color();
    Quantity_Color TheEXTERNALColor =  aEXTERNALColorMapEntry.Color();

    Standard_CString FORWARDStringName (Quantity_Color::StringName(TheFORWARDColor.Name()));
    Standard_CString REVERSEDStringName(Quantity_Color::StringName(TheREVERSEDColor.Name()));
    Standard_CString INTERNALStringName(Quantity_Color::StringName(TheINTERNALColor.Name()));
    Standard_CString EXTERNALStringName(Quantity_Color::StringName(TheEXTERNALColor.Name()));
    FitAll2DViews(Standard_False); // Update Viewer
  // Update Get information to update Result dialog

    UINT anID=ID_BUTTON_Test_Face;
    TCollection_AsciiString Message("Forward is \t");
    Message +=  FORWARDStringName;
    Message += "\nReversed is \t";
    Message +=  REVERSEDStringName;
    Message += "\nInternal is \t";
    Message +=  INTERNALStringName;
    Message += "\nExternal is \t";
    Message +=  EXTERNALStringName;
    Message += "\n";
    Message += "\
------------------------------------------------------------------------------ \n\
create an Sample2D_Face and display it     \n\
------------------------------------------------------------------------------ \n\
//...\n\
    TopoDS_Face aFace;\n\
	BRep_Builder aBuilder;\n\
	Standard_Boolean result = BRepTools::Read(aFace,aFileName,aBuilder);\n\
\n\
    Handle(ISessionSample2D_Face) aDisplayableFace = new ISessionSample2D_Face( aFace  );\n\
    myInteractiveContext2D->Display(aDisplayableFace,  // object\n\
                                    Standard_True);     // Redraw\n\
//...\n\
------------------------------------------------------------------------------ \n\
void _Face::SetContext() \n\
{\n\
    Handle(Prs2d_AspectLine) aLineAspect_FORWARD = new Prs2d_AspectLine;  \n\
    aLineAspect_FORWARD->SetTypeOfFill(Graphic2d_TOPF_EMPTY);\n\
	aLineAspect_FORWARD->SetTypeIndex(myTypeIndex); \n\
    aLineAspect_FORWARD->SetWidthIndex(myWidthIndex);\n\
    aLineAspect_FORWARD->SetColorIndex(myFORWARDColorIndex);\n\
\n\
    Handle(Prs2d_AspectLine) aLineAspect_REVERSED = new Prs2d_AspectLine;  \n\
    aLineAspect_REVERSED->SetTypeOfFill(Graphic2d_TOPF_EMPTY);\n\
    aLineAspect_REVERSED->SetTypeIndex(myTypeIndex);\n\
    aLineAspect_REVERSED->SetWidthIndex(myWidthIndex);\n\
    aLineAspect_REVERSED->SetColorIndex(myREVERSEDColorIndex);\n\
\n\
    Handle(Prs2d_AspectLine) aLineAspect_INTERNAL = new Prs2d_AspectLine;  \n\
    aLineAspect_INTERNAL->SetTypeOfFill(Graphic2d_TOPF_EMPTY);\n\
    aLineAspect_INTERNAL->SetTypeIndex(myTypeIndex);\n\
    aLineAspect_INTERNAL->SetWidthIndex(myWidthIndex);\n\
    aLineAspect_INTERNAL->SetColorIndex(myINTERNALColorIndex);\n\
\n\
    Handle(Prs2d_AspectLine) aLineAspect_EXTERNAL = new Prs2d_AspectLine;  \n\
    aLineAspect_EXTERNAL->SetTypeOfFill(Graphic2d_TOPF_EMPTY);\n\
    aLineAspect_EXTERNAL->SetTypeIndex(myTypeIndex);\n\
    aLineAspect_EXTERNAL->SetWidthIndex(myWidthIndex);\n\
    aLineAspect_EXTERNAL->SetColorIndex(myEXTERNALColorIndex);";

Message +="\
\n\
//pcurves of the face \n\
\n\
    Handle(Graphic2d_SetOfCurves) segment_FORWARD;\n\
    segment_FORWARD = new Graphic2d_SetOfCurves(this); \n\
\n\
    Handle(Graphic2d_SetOfCurves) segment_REVERSED;\n\
    segment_REVERSED = new Graphic2d_SetOfCurves(this); \n\
\n\
    Handle(Graphic2d_SetOfCurves) segment_INTERNAL;\n\
    segment_INTERNAL = new Graphic2d_SetOfCurves(this); \n\
\n\
    Handle(Graphic2d_SetOfCurves) segment_EXTERNAL;\n\
    segment_EXTERNAL = new Graphic2d_SetOfCurves(this); \n\
\n\
    Standard_Real f,l;\n\
    Standard_Integer i = 1;\n\
    myFace.Orientation(TopAbs_FORWARD);\n\
    TopExp_Explorer ex(myFace,TopAbs_EDGE);\n\
    while (ex.More()) {\n\
      const Handle(Geom2d_Curve) Curve = BRep_Tool::CurveOnSurface\n\
	         (TopoDS::Edge(ex.Current()),TopoDS::Face(myFace),f,l);\n\
\n\
      Handle(Geom2d_TrimmedCurve) c = new Geom2d_TrimmedCurve(Curve,f,l);\n\
";
Message += "\
      if (c.IsNull())\n\
      {\n\
        // null curve --> EDGE have a null lenght\n\
        // --> get first and last Vertices\n\
        TopoDS_Edge CurrentEdge= TopoDS::Edge(ex.Current());\n\
\n\
        TopoDS_Vertex FirstVertex = TopExp::FirstVertex(CurrentEdge);\n\
        TopoDS_Vertex LastVertex  = TopExp::LastVertex(CurrentEdge);\n\
\n\
        if (FirstVertex != LastVertex)\n\
          Standard_Failure::Raise(\"Null Edge pcurve But different vertices\");\n\
\n\
         gp_Pnt aPnt  = BRep_Tool::Pnt(FirstVertex);\n\
\n\
        Handle(Graphic2d_Marker) aMarker= \n\
           new Graphic2d_Marker(this,myMarkerIndex,\n\
                                aPnt.X() ,aPnt.Y(),\n\
                                myMarkerWidth,myMarkerHeight,0);\n\
\n\
";
Message += "\
        switch (ex.Current().Orientation())\n\
        {\n\
          case TopAbs_FORWARD:  aMarker->SetColorIndex (myFORWARDColorIndex);   break;\n\
          case TopAbs_REVERSED: aMarker->SetColorIndex (myREVERSEDColorIndex);  break;\n\
          case TopAbs_INTERNAL: aMarker->SetColorIndex (myINTERNALColorIndex);  break;\n\
          case TopAbs_EXTERNAL: aMarker->SetColorIndex (myEXTERNALColorIndex);  break;\n\
          default : break;\n\
        }\n\
        ex.Next();\n\
      }\n\
      else\n\
      {\n\
        // Display the Curve\n\
        // display the orientation\n\
\n\
        gp_Pnt2d p1,p2;\n\
        gp_Vec2d v;\n\
        c->D1(l,p1,v);\n\
        Graphic2d_Array1OfVertex aListVertex(1,3);\n\
        if (v.Magnitude() > gp::Resolution()) {\n\
            Standard_Real L = 2;\n\
            Standard_Real H = 1;\n\
            gp_Dir2d d(v);\n\
            p2.SetCoord(- L*d.X() - H*d.Y(),- L*d.Y() + H*d.X());\n\
            aListVertex(1)=Graphic2d_Vertex(p2.X(),p2.Y());\n\
            \n\
            p2.SetCoord(- L*d.X() + H*d.Y(),- L*d.Y() - H*d.X());\n\
            aListVertex(2)=Graphic2d_Vertex(0.,0.);\n\
            aListVertex(3)=Graphic2d_Vertex(p2.X(),p2.Y()); \n\
        }\n\
";
Message += "\
\n\
        Handle(Graphic2d_PolylineMarker) aMarker= \n\
          new Graphic2d_PolylineMarker(this,p1.X(),p1.Y(),aListVertex);\n\
\n\
  		switch (ex.Current().Orientation()) \n\
        {\n\
        case TopAbs_FORWARD: {\n\
             segment_FORWARD->Add(c); \n\
             SetAspect(aLineAspect_FORWARD, aMarker);  \n\
             break;\n\
        }\n\
        case TopAbs_REVERSED: {\n\
             segment_REVERSED->Add(c); \n\
             SetAspect(aLineAspect_REVERSED, aMarker); \n\
             break; \n\
        } \n\
        case TopAbs_INTERNAL: { \n\
             segment_INTERNAL->Add(c); \n\
             SetAspect(aLineAspect_INTERNAL, aMarker); \n\
             break; \n\
        } \n\
        case TopAbs_EXTERNAL: { \n\
             segment_EXTERNAL->Add(c); \n\
             SetAspect(aLineAspect_EXTERNAL, aMarker); \n\
             break; \n\
        } \n\
        default : break; \n\
        } \n\
      }\n\
      ex.Next();\n\
    }\n\
\n\
	SetAspect(aLineAspect_FORWARD, segment_FORWARD);\n\
	SetAspect(aLineAspect_REVERSED, segment_REVERSED);\n\
	SetAspect(aLineAspect_INTERNAL, segment_INTERNAL);\n\
	SetAspect(aLineAspect_EXTERNAL, segment_EXTERNAL);\n\
\n\
}\n\
";


  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
  }
}


