/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_RECORDLOGTOCAPABILITIESACCESS_H_
#define OPENDRIM_RECORDLOGTOCAPABILITIESACCESS_H_

#include "OpenDRIM_RecordLogPackage_Common.h"

#include "OpenDRIM_RecordLogToCapabilities.h"
#include "assocOpenDRIM_RecordLogToCapabilities.h"

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_unload(string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RecordLogToCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RecordLogToCapabilities& instance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogToCapabilities& newInstance, const OpenDRIM_RecordLogToCapabilities& oldInstance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogToCapabilities& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogToCapabilities& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_RecordLogToCapabilities>& OpenDRIM_RecordLogToCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_RecordLogToCapabilities>& OpenDRIM_RecordLogToCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogToCapabilities_populate(OpenDRIM_RecordLogToCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_RECORDLOGTOCAPABILITIESACCESS_H_*/
