#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Monkey Island 3
###

script_version=20240528.2

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='monkey-island-3'
GAME_NAME='Monkey Island 3: The Curse of Monkey Island'

ARCHIVE_BASE_EN_1_NAME='setup_the_curse_of_monkey_islandtm_1.0l_(20628).exe'
ARCHIVE_BASE_EN_1_MD5='fcd4a7cd9c0304c15a0a059f6eb299e8'
ARCHIVE_BASE_EN_1_TYPE='innosetup'
ARCHIVE_BASE_EN_1_PART1_NAME='setup_the_curse_of_monkey_islandtm_1.0l_(20628)-1.bin'
ARCHIVE_BASE_EN_1_PART1_MD5='931e6e35fdc7e0a14f2559984620f8f3'
ARCHIVE_BASE_EN_1_SIZE='1200000'
ARCHIVE_BASE_EN_1_VERSION='1.0l-gog20628'
ARCHIVE_BASE_EN_1_URL='https://www.gog.com/game/the_curse_of_monkey_island'

ARCHIVE_BASE_FR_1_NAME='setup_the_curse_of_monkey_islandtm_1.0l_(french)_(20628).exe'
ARCHIVE_BASE_FR_1_MD5='a0ebaa26154de4a76d20b0ef882445cf'
ARCHIVE_BASE_FR_1_TYPE='innosetup'
ARCHIVE_BASE_FR_1_PART1_NAME='setup_the_curse_of_monkey_islandtm_1.0l_(french)_(20628)-1.bin'
ARCHIVE_BASE_FR_1_PART1_MD5='10356610b119b917dbba13df9ed207a5'
ARCHIVE_BASE_FR_1_SIZE='1200000'
ARCHIVE_BASE_FR_1_VERSION='1.0l-gog20628'
ARCHIVE_BASE_FR_1_URL='https://www.gog.com/game/the_curse_of_monkey_island'

ARCHIVE_BASE_EN_0_NAME='setup_the_curse_of_monkey_island_1.0_(18253).exe'
ARCHIVE_BASE_EN_0_MD5='20c74e5f60bd724182ec2bdbae6d9a49'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='1200000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog18253'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_EN_0='app'
CONTENT_GAME_L10N_FILES='
resource/bbsan.san
resource/curserng.san
resource/finale.san
resource/language.tab
resource/lavaride.san
resource/liftcrse.san
resource/moreslaw.san
resource/newboots.san
resource/opening.san
resource/sinkshp.san
resource/voxdisk1.bun
resource/voxdisk2.bun
resource/wrecksan.san'
CONTENT_GAME_MAIN_FILES='
comi.la?
resource'
CONTENT_DOC_L10N_FILES='
*.pdf'

APP_MAIN_SCUMMID='scumm:comi'
APP_MAIN_ICON='app/goggame-1528148981.ico'

PACKAGES_LIST='
PKG_L10N
PKG_MAIN'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_MAIN_DEPS="$PKG_L10N_ID"

# Work around "insufficient image data" issue with convert from imagemagick

SCRIPT_DEPS="${SCRIPT_DEPS:-} icotool"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

## Work around "insufficient image data" issue with convert from imagemagick.
icon_extract_png_from_ico() {
	local icon destination
	icon="$1"
	destination="$2"

	local icon_file
	icon_file=$(icon_full_path "$icon")
	icotool --extract --output="$destination" "$icon_file" 2>/dev/null
}
content_inclusion_icons 'PKG_MAIN'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_MAIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
