# Check for the presence of optional extra archives
# USAGE: archives_optional_extra_presence_check
archives_optional_extra_presence_check() {
	# Check for the presence of an optional icons pack
	local icons_pack_name
	icons_pack_name=$(context_value 'ARCHIVE_OPTIONAL_ICONS_NAME')
	if [ -n "$icons_pack_name" ]; then
		## Set contextual values, for game scripts with support for multiple games.
		ARCHIVE_OPTIONAL_ICONS_NAME=$(context_value 'ARCHIVE_OPTIONAL_ICONS_NAME')
		ARCHIVE_OPTIONAL_ICONS_MD5=$(context_value 'ARCHIVE_OPTIONAL_ICONS_MD5')
		ARCHIVE_OPTIONAL_ICONS_URL=$(context_value 'ARCHIVE_OPTIONAL_ICONS_URL')
		export ARCHIVE_OPTIONAL_ICONS_NAME ARCHIVE_OPTIONAL_ICONS_MD5 ARCHIVE_OPTIONAL_ICONS_URL
		archive_initialize_optional \
			'ARCHIVE_ICONS' \
			'ARCHIVE_OPTIONAL_ICONS'
		if ! archive_is_available 'ARCHIVE_ICONS'; then
			warning_optional_archive_missing_icons 'ARCHIVE_OPTIONAL_ICONS'
		fi
	fi
}

