#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include "q-lib.h"

static int
grab_mappings (pid_t pid)
{
  char buf[PATH_MAX], last_path[PATH_MAX], *line = NULL, *name;
  size_t line_size = 0;
  FILE *fp;

  snprintf (buf, sizeof (buf), "/proc/%d/maps", pid);
  fp = fopen (buf, "r");
  if (!fp)
    {
      /* process gone? */
      perror (buf);
      return -1;
    }

  last_path[0] = '\0';

  while (getline (&line, &line_size, fp) > 0)
    {
      unsigned long start, end, offset;
      char path[PATH_MAX], perm[4];

      if (sscanf (line, "%lx-%lx %4s %lx %*x:%*x %*u %4096s\n",
		  &start, &end, perm, &offset, path) == 5)
	{
	  if (strncmp (perm, "---", 3) == 0)
	    /* ignore inaccessible mappings */
	    continue;

#if 0
	  printf ("%s: start=%lx, size=%lu, off=%lx, path=%s\n",
		  __FUNCTION__, start, end - start, offset, path);
#endif
	  if (!path[0])
	    continue;

	  name = strrchr (path, '/');
	  if (name)
	    ++name;
	  else
	    name = path;

	  if (!last_path[0] || strcmp (path, last_path) != 0)
	    {
	      if (last_path[0])
		printf ("))))\n");

	      q_checksummed_link (Q_LINK_ANY, buf, sizeof (buf), name, path);
	      printf ("(q:object '((q:name . \"%s\")\n"
		      "            (q:file . \"%s\")\n"
		      "            (q:maps . (", name, buf);
	      strcpy (last_path, path);
	    }
	  else
	    printf ("\n                       ");

	  printf ("((q:addr . #x%lx) (q:size . %lu) (q:offset . #x%lx))",
		  start, end - start, offset);
	}
    }
  if (last_path[0])
    printf ("))))\n");
  if (line)
    free (line);
  fclose (fp);
  return 0;
}

int
main (int argc, char **argv)
{
  if (argc != 2)
    {
      fprintf (stderr, "Usage: %s pid\n", argv[0]);
      exit (-1);
    }
  return grab_mappings (atol (argv[1]));
}
