/* This file is part of q-tools, a collection of performance tools
   Copyright (c) 2003 Hewlett-Packard Development Company, L.P.
   Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA  02111-1307  USA  */

#ifndef sysprof_h
#define sysprof_h

#ifdef __GNUC__
# define likely(x)	(__builtin_expect ((long) (x), 1))
# define unlikely(x)	(__builtin_expect ((long) (x), 0))
#else
# define likely(x)	(x)
# define unlikely(x)	(x)
#endif

extern void prog_stop (int exit_status);

#define panic(args...)				\
do {						\
  fprintf (stderr, ##args);			\
  prog_stop (1);				\
} while (0)

#define INSN_SHIFT	2	/* log2() of the min. size of an instruction */

/*
 * for i386, this is an approximation and KERNEL_START/KERNEL_SIZE
 * can be adjusted at compile time based on the memory management scheme
 * (e.g. HIGMEM)
 */
#ifdef __ia64__
#define KERNEL_START	0xa000000000000000
#define KERNEL_SIZE	0x6000000000000000
#elif defined(__i386__)
#define KERNEL_START	0xC0000000
#define KERNEL_SIZE	(1UL <<30)
#elif defined(__x86_64__)
#define KERNEL_START	0xffff810000000000
#define KERNEL_SIZE	(1UL <<30)
#else
#error "you need to define KERNEL_START and KERNEL_SIZE"
#endif

struct mapping
  {
    struct mapping *next;	/* must be first member in this structure! */
    unsigned long start;
    unsigned long size;
    unsigned long offset;
    const char *path;
  };

struct addr_space
  {
    struct addr_space *next;
    pid_t pid;
    pid_t tgid;		/* thread-group id (defaults to same as pid) */
    const char *name;
    const char **argv;
    struct time_hist *hist;
    struct call_count *cc;
    struct mapping *mappings;
  };

#include <perfmon/perfmon.h>
#include <perfmon/perfmon_dfl_smpl.h>
#include <perfmon/pfmlib.h>

struct qsys_btb_support
  {
    int pmu_type;
    void (*setup_btb_code_sampling)(pfarg_pmc_t *pc, int *npmcs, pfarg_pmd_t *pd, int *npmds, unsigned int plm, pfarg_pmd_t **cs_pd);
    void (*setup_call_count_sampling)(pfarg_pmc_t *pc, int *npmcs, pfarg_pmd_t *pd, int *npmds, unsigned int plm, pfarg_pmd_t **b_pd);
    char *(*process_btb_sample)(struct addr_space *as, pfm_dfl_smpl_entry_t *ent, char *pos);
    uint64_t (*get_ip_from_btb)(pfm_dfl_smpl_entry_t *ent, char **posp);
  };

extern void check_addr_space_mapping (struct addr_space *as, unsigned long addr);

extern unsigned int cs_event_code, cs_cycle_code;
extern unsigned long cycle_frequency;
extern double code_sample_rate;
extern double call_sample_rate;



#define NELEMS(a)		((sizeof (a) / sizeof (a[0])))
#define REG_MASK(regnum)	(1UL << (regnum))

#define KB			(1 << 10)
#define SAMPLING_BUFFER_SIZE	(256*KB)

#endif /* sysprof_h */
