
#ifndef __IMPORT_DVDAUTHOR_H__
#define __IMPORT_DVDAUTHOR_H__

#include <qvaluelist.h>

class SourceFileEntry;
class CXmlDVDAuthor;
class CXmlSpumux;
class VMGMenu;
class DVDMenu;
class ImageObject;

namespace Import
{

class DVDAuthor
{
public:
   DVDAuthor ( QDVDAuthor * );
  ~DVDAuthor ();
  
  bool                          import               ();
  void                          clear          ( bool );
  QValueList<DVDMenu *>         takeDVDMenus         ();
  VMGMenu                      *takeVMGMenu          ();
  QValueList<SourceFileEntry *> takeSourceFileEntries();
  bool buildFromDVDAuthorXML ( CXmlDVDAuthor *, QValueList<CXmlSpumux *> &);

private:
  bool buildFromVMGM         ( CXmlDVDAuthor::vmgm_struct     * );
  bool buildFromTitleset     ( CXmlDVDAuthor::titleset_struct * );
  bool buildFromMenus        ( CXmlDVDAuthor::menus_struct    *, VMGMenu *p=NULL );
  bool buildMenuFromPgc      ( CXmlDVDAuthor::pgc_struct      *, VMGMenu *p=NULL );
  bool buildButtonFromPgc    ( CXmlDVDAuthor::button_struct   *, DVDMenu * );
  bool buildTitleFromPgc     ( CXmlDVDAuthor::pgc_struct      * );
  bool buildFromTitles       ( CXmlDVDAuthor::titles_struct   * );

  bool buildFromSpumuxXML    ( CXmlSpumux * );
  DVDMenu *findMenuFromSpumux( CXmlSpumux * );
  DVDMenu *findMenuFromSubpicture ( CXmlSpumux::subpictures_struct * );
  DVDMenu *findMenuFromStream( CXmlSpumux::stream_struct * );
  DVDMenu *findMenuFromSpu   ( CXmlSpumux::spu_struct * );
  DVDMenu *addSpuInfoToMenu  ( CXmlSpumux::spu_struct *, DVDMenu * );

  ButtonObject *findXMLButtonInList     ( QValueList<ButtonObject *> &, CXmlSpumux::button_struct * );
  ImageObject  *getButtonImageFromLayer ( DVDMenu *, QRect &, QString );
  CXmlSpumux::button_struct *findButtonObjectInArray ( CXmlSpumux::button_struct **, ButtonObject * );

private:
  QDVDAuthor                   *m_pDVDAuthor;
  QValueList<DVDMenu *>         m_listDVDMenus;
  VMGMenu                      *m_pVMGMenu;
  QValueList<SourceFileEntry *> m_listSourceFileEntries;
  int                           m_iCurrentTitleset;
};

}

#endif // __IMPORT_DVDAUTHOR_H__
