/****************************************************************************
** Subtitles - class
**
** Created: Tue Dec 27 12:09:08 2006
**      by: Varol Okan using XEmacs editor
**
** This class encapsulates the attributes or the Subtitle generation.
**
****************************************************************************/

#ifndef __SUBTITLES_H__
#define __SUBTITLES_H__

#include <qstringlist.h>
#include <qfont.h>
#include <qrect.h>
#include <qcolor.h>

class QDomNode;
class QDomElement;

class SourceFileInfo;

// MAX_SUBTITLE_COLORS 4 does not work as ImageMagick counts 5 in some cases using spumux.
#define MAX_SUBTITLE_COLORS  3
#define MAX_SUBTITLES       32

class SubtitleEntry 
{
public:
  SubtitleEntry ( );
  SubtitleEntry &operator = ( SubtitleEntry & );
  QString m_qsIso639;
  int     m_iSubtitleNumber;
};

class Subtitles : public SubtitleEntry
{
public:
  enum enState {
    STATE_MANUAL = 0, // User imported or manually entered this subtitle
    STATE_EXTRACTING, // Subtitle is being extracted from meta info in background task
    STATE_META_INFO   // Subtitle was created using videos Meta information
  };

  class entry {
  public:
    entry ();
    entry &operator = ( entry & );

    int     iIndex;
    QString qsTimeStart;// 00:00:00.000
    QString qsTimeStop; // 00:00:00.000
    long    iTimeStart; // in ms
    long    iTimeStop;  // in ms
    QString qsText;
    QRect   rect;       // Note not stored as it is created when drawing the text.
  };

   Subtitles ();
  ~Subtitles ();

  Subtitles & operator =    ( Subtitles   & );
  bool    readProjectFile   ( QDomNode    & );
  bool    writeProjectFile  ( QDomElement & );
  long    getTimeFromString ( QString     & );
  QString getStringFromTime ( long          );
  QString getXMLFileName    (               );

  void    render            ( QString, QString );

  // static fnc to register for background subtitle extraction ...
  static void generateSubtitles ( QObject *, SourceFileInfo *, QString );

private: // private member functions.
  QRect   getSubtitlesRect  ( QString & );

public:
  enState              m_subtitleState;
  bool                 m_bTextSubtitles;
  QString              m_qsTextFont;
  int                  m_iTextFontSize;
  bool                 m_bFit;
  int                  m_iOutline;
  QFont                m_font;
  QRect                m_rect;
  QPoint               m_alignment;
  QValueList <entry *> m_listOfSubtitles;
  // this is the file that is going to be created.
  QString              m_qsTempFile; 
  QColor               m_subColors[ MAX_SUBTITLE_COLORS ];
  unsigned char        m_subTransparency [ MAX_SUBTITLE_COLORS ]; // 0 .. 255
  QString              m_qsXmlFile; // holds the full path of the xml file.
};

#endif // __SUBTITLES_H__

