#!/bin/bash

# First we clean up a little ...
if [ -e qdvdauthor/.obj ]; then
	./clean.sh
fi;
if [ -e qdvdauthor/CONFIG.h ]; then
	rm qdvdauthor/CONFIG.h
fi;
if [ -e qdvdauthor/qplayer/MEDIA_CONFIG.h ]; then
	rm qdvdauthor/qplayer/MEDIA_CONFIG.h
fi;
if [ -e qrender/ffmpeg ]; then
	rm qrender/ffmpeg
fi;

# here we print all *.ui files which are not conform to the Qt 3.1 version requirement
find . -name "*.ui" -exec grep DOCTYPE {} \; | grep -v 3.1

# Here we get the version number from the SPEC file.
version=`cat qdvdauthor.spec | grep Version | awk '{ print $2;}' | tr -d "\r\n"`
echo "qdvdauthor.spec version is   :  $version"

xml_version=`grep QDVDAUTHOR_VERSION_NUMBER qdvdauthor/xml_dvd.h | awk '{ print $3 }'`;
echo "XML version ( xml_dvd.h ) is : $xml_version"

# now we create the directory
CURRENT_PATH=`pwd`
cd ..
mkdir qdvdauthor-$version
cp -R $CURRENT_PATH/* qdvdauthor-$version/

# Finally we create the tarball
tar -czf qdvdauthor-$version.tar.gz qdvdauthor-$version


