#!/bin/bash

# Here we create the dummy config files ...
echo "#ifndef CONFIG_H" > qdvdauthor/CONFIG.h
echo "#define CONFIG_H" >> qdvdauthor/CONFIG.h
echo "#define PREFIX_DIRECTORY $PREFIX" >> qdvdauthor/CONFIG.h
echo "#endif // CONFIG_H" >> qdvdauthor/CONFIG.h

echo "#ifndef MEDIA_CONFIG_H" > qdvdauthor/qplayer/MEDIA_CONFIG.h
echo "#define MEDIA_CONFIG_H" >> qdvdauthor/qplayer/MEDIA_CONFIG.h
echo "#define XINE_SUPPORT $WITH_XINE_SUPPORT" >> qdvdauthor/qplayer/MEDIA_CONFIG.h 
echo "#define MPLAYER_SUPPORT $WITH_MPLAYER_SUPPORT" >> qdvdauthor/qplayer/MEDIA_CONFIG.h
echo "#define VLC_SUPPORT $WITH_VLC_SUPPORT" >> qdvdauthor/qplayer/MEDIA_CONFIG.h
echo "#endif // MEDIA_CONFIG_H" >> qdvdauthor/qplayer/MEDIA_CONFIG.h

# Next we set all *.ui filess back to Qt version 3.1
cd qdvdauthor
find . -name "*?.ui" | while read ui_file
do
	replace=`grep DOCTYPE $ui_file | grep -v 'version="3.1"'`
	# And if we found some other then version 3.1 we change it back ...
	if [ "" != "$replace" ];
	then
        	echo $ui_file = "$replace"
	        mv $ui_file $ui_file.old
        	cat $ui_file.old | sed s/"$replace"/'<!DOCTYPE UI><UI version="3.1" stdsetdef="1">'/ > $ui_file
		rm $ui_file.old
	fi;
done;
cd ..

rm Makefile
cd bin
rm configurator
rm qdvdauthor
rm qslideshow
rm qplayer
rm qrender
rm core*

# This script cleans all sub projects for a neat and compact directory.
cd ../configurator/; make clean 
rm Makefile *~ core*
rm -r .ui .moc .obj

cd ../addons/
./make.sh clean

cd ../qdvdauthor/; make clean 
rm Makefile *~
rm i18n/*.qm
rm CONFIG.h
rm core*

if [ -e tools ];
then
  cd tools; make clean
  rm core*
  cd ..
fi;

cd qslideshow/; make clean
rm Makefile *~
rm -r .ui .moc .obj
rm core*

cd ../qplayer/; make clean
rm Makefile *~ engines/*~
rm MEDIA_CONFIG.h
rm core*

# Old QRender path. Deprecated
cd ../qrender/; make clean
rm Makefile *~ engine/*~
rm core* engine/core*

cd ../plugins/
./make.sh clean
rm plugins/lib*.so*

cd ../
rm -r .ui .moc .obj
rm core*

cd ../manual/; make clean
rm core*

cd ../qrender/; make clean
rm -rf Makefile *~ .obj .ui .moc 
rm core* ffmpeg ffmpeg-export-snapshot.tar ffmpeg

ffmpegDir=`ls -d ffmpeg-* 2>/dev/null`
if [ "$ffmpegDir" != "" ]; then
  if [ -d "$ffmpegDir" ]; then 
    rm -rf "$ffmpegDir"
  fi
fi

cd ..
sourceFiles=`cat \`find . -name "*.cpp"\` | wc -l`
sourceHeader=`cat \`find . -name "*.h"\`  | wc -l`
echo "Source=$sourceFiles + Header=$sourceHeader  => LOC=$(( sourceFiles + sourceHeader ))"
echo


