/****************************************************************************
** Class Utils implementation ...
**
**   Created : Wed Jun 17 07:53:05 2008
**        by : Varol Okan
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** Here we have some misc functions which are needed by a few classes 
** but can not really be assigned to any of those classes.
**
****************************************************************************/

#include "encoder.h"

namespace Encoder
{

Encoder::Encoder ( )
{
  m_VideoFormat   = vfNTSC;
  m_AudioFormat   = afAC3;
  m_AspectRatio   = arAspect4to3;
  m_iVideoBitrate = 6000;
  m_iAudioBitrate = 224000;
  m_iAudioSample  = 48000;
  m_iTotalFrames  = 1;
}

Encoder::~Encoder ( )
{
}

bool Encoder::initStream ( QString qsFileName, enVideo videoFormat, enAudio audioFormat, uint iFrames )
{
  m_qsFileName   = qsFileName;
  m_VideoFormat  = videoFormat;
  m_AudioFormat  = audioFormat;
  m_iTotalFrames = iFrames;
  return true;
}

void Encoder::endStream ( )
{
}

void Encoder::setVideoParam ( uint iBitrate, enAspect )
{
  m_iVideoBitrate = iBitrate;
}

void Encoder::setAudioParam ( uint iBitrate, int iSample ) // 192000, 4800
{
  m_iAudioBitrate = iBitrate;
  m_iAudioSample  = iSample;
}

QString &Encoder::getFileName   ( )
{
  return m_qsFileName;
}

void Encoder::setAudioList ( QStringList list )
{
  m_audioList = list;
}

}; // end of namespace Encoder
