/****************************************************************************
** Interface to the GUI.
**
**   Created : Mon May 30 22:48:00 2006
**        by : Varol Okan using xemacs
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
**
****************************************************************************/

#ifndef TEMPLATEDOWNLOAD_H
#define TEMPLATEDOWNLOAD_H

#include <qdom.h>
#include <qimage.h>
#include <qurloperator.h>

// the designer created GUI.
#include "uitemplatedownload.h"

#define TEMPLATES_DOCTYPE             ""
// Here we define all attributes for the structures.
#define TEMPLATES_TEMPLATES           "Templates"
#define TEMPLATES_ENTRY               "Entry"

#define TEMPLATES_ENTRY_DESCRIPTION   "Description"
#define TEMPLATES_ENTRY_THUMBNAIL     "Thumbnail"
#define TEMPLATES_ENTRY_LOCATION      "Location"

#define TEMPLATES_ATTRIB_NAME         "name"
#define TEMPLATES_ATTRIB_TYPE         "type"
#define TEMPLATES_ATTRIB_SIZE         "size"

class QProcess;

class TemplateDownload : public uiTemplateDownload
{
  Q_OBJECT
protected:
  class Xml
  {
  public:
    class Entry {
    public:
       Entry ( );
      ~Entry ( ) { };

      QString qsName;
      QString qsType; // either static, animated or transition
      QString qsDescription;
      QString qsThumbnail;
      int     iThumbnailSize;
      QImage  theThumbnail;
      QString qsLocation;
      int     iLocationSize;
      bool    bSelectedForInstall;
    };

     Xml ( ) { };
    ~Xml ( ) { clear ( ); };

    bool parseXml  ( QString & );

    Entry  *entry  ( int i );
    int entryCount ( ){ return  (int)m_listOfEntries.count(   ); };
    void    clear  ( );

  private:
    QPtrList<Entry> m_listOfEntries;
  };

public:
	 TemplateDownload (QWidget * parent=NULL, const char * name = 0, WFlags f = 0 );
	~TemplateDownload ();

private:
	void resetDialog       ( );
	void parseIndexFile    ( );
	void createThumbnail   ( );
	void createThumbnails  ( );
	bool verifyUrl         ( QString & );
	void displayStatus     ( QString & );
	void installToSystem   ( QString &, bool );
	void lockDialog        ( bool );
	void downloadTemplate  ( int );
	void installTemplates  ( );
	void downloadThumbnail ( int );
	void downloadThumbnails( );
	// For the second tab
	void createSelection   ( );

protected slots:
	virtual void slotConnect  ( );
	virtual void slotNext     ( );
	virtual void slotHelp     ( );
	virtual void slotDownload ( );

	virtual void slotNetworkStart    ( QNetworkOperation * );
	virtual void slotNetworkFinished ( QNetworkOperation * );
	virtual void slotNetworkData     ( const QByteArray &, QNetworkOperation * );
	virtual void slotNetworkProgress ( int, int, QNetworkOperation * );
	virtual void slotReadFromProcess ( );
	virtual void slotProcessExited   ( );

protected:
	QString      m_qsIndexFile; // XML file from server describing available templates.
	QUrlOperator m_Network;
	QProcess    *m_pNewProcess;
	QCString     m_bytes;
	int          m_iStage;     // get index.xml, DL thumbnails ...
	int          m_iCurrentEntry;
	long         m_iCurrentBytes;
	long         m_iTotalBytes;
	Xml          m_xml;
};

#endif // TEMPLATEDOWNLOAD_H

