/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.cliparams;

import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.util.StringUtils;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CliParamProcessor {
    protected ParamConfig paramConfig;
    protected String[] commandLineArgs = null;

    public CliParamProcessor(ParamConfig paramConfig, String[] commandLineArgs) {
        this.paramConfig = paramConfig;
        if (commandLineArgs != null) {
            this.commandLineArgs = (String[])commandLineArgs.clone();
        }
    }

    public abstract void loadOptions(Options var1) throws CliCommandoException;

    public abstract void loadValuesFromCommandLine(CommandLine var1) throws CliCommandoException;

    protected void validateOptions(List<OptionConfig> optionConfigList) throws CliCommandoException {
        if (optionConfigList.size() == 0) {
            throw new ConfigurationErrorException("Empty option list for parameter: " + this.paramConfig.getName());
        }
        for (OptionConfig optionConfig : optionConfigList) {
            StringUtils.validateAtLeastOneNotEmpty(optionConfig.getShortOpt(), optionConfig.getLongOpt());
        }
    }

    protected String getUsedOptionName(CommandLine line, OptionConfig optionConfig) {
        String name = optionConfig.getLongOpt();
        if (name != null && line.hasOption(name)) {
            return name;
        }
        name = optionConfig.getShortOpt();
        if (name != null && line.hasOption(name)) {
            return name;
        }
        return null;
    }

    public void setIfParamIsSpecifiedOnCommandLine(CommandLine line) {
        String usedOptionName = this.getUsedOptionName(line, this.paramConfig.getFirstOption());
        if (usedOptionName != null) {
            this.paramConfig.setIsSpecified(true);
        } else {
            this.paramConfig.setIsSpecified(false);
        }
    }
}

