\name{plotList}
\alias{plotList}
\title{Collection of Plot description/templates}
\description{
 This is used to gather individual plot description
 or template objects into a collection
 to make it easier to dispatch methods
 and also to optionally associate a layout for this collection.
 This essentially acts as another form of template
 or display description.
}
\usage{
plotList(..., mfrow=NULL, cells=NULL)
}
\arguments{
  \item{\dots}{one or more plot description objects.}
  \item{mfrow}{the grid dimensions for arranging the plot
   in \code{\link{plotLayout}}}
  \item{cells}{the cells the individual plots are to occupy
   in the grid layout. These are typically computed by a call
   to \code{\link{gtkCells}}.}
}

\value{
 A list containing the arguments
 \item{plots}{ a list }
 \item{mfrow}{}
 \item{cells}{}
 given as an object of  class \code{ggobiPlotList}
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{ 
 \code{\link{ashDescription}}
 \code{\link{scatterplotDescription}}
 \code{\link{scatmatrixDescription}}
 \code{\link{parallelCoordDescription}}
 \code{\link{plotLayout}}
 \code{\link{resolvePlotDescription}}
}

\examples{
  plotList(ashDescription("tars1"), scatterplotDescription("tars1", "head"))
}
\concept{visualization}
\concept{interactive graphics}

\keyword{device}
