\name{setDisplayOptions.ggobi}
\alias{setDisplayOptions.ggobi}
\alias{getDisplayOptions.ggobi}
\title{Controls the basic display settings for ggobi}
\description{
 This allows one to set the settings that control
how ggobi displays its plots.
These have effect on all plots created after the settings
have been registered, and are not applied to existing plots.
}
\usage{
getDisplayOptions.ggobi(which=1, .gobi=getDefaultGGobi())
setDisplayOptions.ggobi(points, axes, axesLabels, axesValues,
                         directed, undirected, arrowheads,
                          whiskers, current = NULL,
                           display = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{which}{the identifier for the display of interest, either an index
   or a \code{ggobiDisplay} object.}
 \item{display}{the display identifier, either an integer giving the index in the list of displays
   within the GGobi instance, or an object of class \code{ggobiDisplay}}
 \item{points}{logical value indicating whether points are to be
   displayed on a plot.}
 \item{axes}{whether the rulers/axes should be visible on the display or
   not.}
 \item{axesLabels}{a logical value controlling  whether the axes are
    show within a tour.}
 \item{axesValues}{a logical value, whether the  current values for the
   different axes are displayed on the plot within a tour.}  
 \item{directed}{logical value indicating whether the line segments are to be shown as directed 
    (TRUE) or undirected (FALSE) line segments.}
 \item{undirected}{whether line segments are to be shown or not.}
 \item{arrowheads}{whether to show arrowheads on the line segments}
 \item{whiskers}{whether to show whiskers in time-series or parallel
    coordinate plots, or edges in scatter plots.}
 \item{current}{a logical vector giving values for the individual
    settings. This is typically obtained from calling
    \code{\link{getDisplayOptions.ggobi}} and then modifying
    the individual entries.
    One can also specify the individual values with the earlier
    arguments.
   }
 \item{.gobi}{the ggobi instance for which the settings are to be
    applied.
    If this is NULL, the settings are applied to the default options
    and will affect displays created subsequently. In other words,
    one can specify default values for new displays.}
}

\value{
 The previous settings that were in effect 
before this call.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{getDisplayOptions.ggobi}}
}

\examples{
 # untested

 data(mtcars)
 ggobi(mtcars)

 old <- setDisplayOptions.ggobi(axes=FALSE)
 scatterplot.ggobi("mpg", "am")

   # restore the old settings.
 setDisplayOptions.ggobi(old)
}
\keyword{iplot}
