\name{setDisplayWidth.ggobi}
\alias{setDisplayWidth.ggobi}
\alias{getDisplayWidth.ggobi}
\title{Controls the size of a ggobi display window}
\description{
 On occassion, it is convenient  to be able to programmatically
 change the size of a window housing a ggobi display.
 This function attempts to allow one to do this.

 See the RGtk package and \code{\link[RGtk]{gtkWidgetSetUsize}}.
}
\usage{
setDisplayWidth.ggobi(sz, display=1, .gobi=getDefaultGGobi())
getDisplayWidth.ggobi(display=1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{sz}{a vector giving the width and height to which 
    the dimensions of the display window should be set.}
  \item{display}{an identifier for the particular display within the ggobi instance.
   This can be either an object of class \code{ggobiDisplay}
   or an integer.}
  \item{.gobi}{the ggobi instance in which to resolve the \code{display}.
     This can be an object of class \code{ggobi} or an integer identifying
    it by position in the list returned by \code{\link{getGGobi}}.}
}
\details{
  This attempts to set the dimensions of the Gnome window.
}
\value{
 The return value of these two functions
 is an integer vector containing the
 dimension (width and height) of the
 window before this function was called.
 In the case of \code{setDisplayWidth.ggobi},
 this value is the old setting.

 At present, these return \code{c(0,0)}.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{ 
 The plot creation functions
 \code{\link{scatmat.ggobi}},
 \code{\link{scatterplot.ggobi}}
 \code{\link{parcoords.ggobi}}.
}

\examples{
    g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
    g$setDisplayWidth(c(200, 300), 1)
}
\keyword{iplot}
\keyword{dynamic}
