/*
 * Copyright (c) 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.explain.view;

/**
 * ExplainViewListener.java
 *
 * The listener interface for receiving ExplainView events. Those
 * classes wishing to receive {@link ExplainViewEvent
 * ExplainViewEvents} should implement this interface and register
 * themselves with any {@link ExplainView} objects that they want to
 * receive events from.
 *
 * @author Liam Stewart
 * @version 1.2.0
 */

public interface ExplainViewListener extends java.util.EventListener {
	/**
	 * A zoom has occurred.
	 *
	 * @param e an <code>ExplainViewEvent</code> value
	 */
	public void explainViewZoomed(ExplainViewEvent e);

	/**
	 * The overview window has been closed.
	 *
	 * @param e an <code>ExplainViewEvent</code> value
	 */
	public void explainViewOverviewWindowClosed(ExplainViewEvent e);

	/**
	 * The EXPLAIN window has been closed.
	 *
	 * @param e an <code>ExplainViewEvent</code> value
	 */
	public void explainViewExplainWindowClosed(ExplainViewEvent e);

	/**
	 * The EXPLAIN VERBOSE window has been closed.
	 *
	 * @param e an <code>ExplainViewEvent</code> value
	 */
	public void explainViewExplainVerboseWindowClosed(ExplainViewEvent e);

	/**
	 * The planner options window has been closed.
	 *
	 * @param e an <code>ExplainViewEvent</code> value
	 */
	public void explainViewOptionsWindowClosed(ExplainViewEvent e);
}// ExplainViewListener
