/////////// rtini.cpp //////////////////////
/////////// Implements INI files. //////////

#include "rtini.h"

#include "rtstreams.h"
#include "rtresource.h"
//#include "rtstring.h"
//#include "rtmap.h"

namespace lrt {

IniFile::IniFile() : data(false)
{
}

IniFile::IniFile(const String& filename) : data(false)
{
	read(filename);
}

bool IniFile::hasSection(const String& name) const
{
	return data.isSet(name);
}

IniSection& IniFile::getSection(const String& name)
{
	return data.get(name);
}

const IniSection& IniFile::getSectionConst(const String& name) const
{
	return data.get(name);
}

void IniFile::addSection(const String& name, const IniSection& section)
{
	data.put(name, section);
}

bool IniFile::removeSection(const String& name)
{
	return data.remove(name);
}

IniFile::Iterator IniFile::begin()
{
	return data.begin();
}

IniFile::Iterator IniFile::begin() const
{
	return data.begin();
}

bool IniFile::read(const String& filename)
{
	InputStream* resin = Resource::getResource(filename); // P.I.S. will delete it for us!
	if(resin == 0) return false;
	ParseInputStream *in = new ParseInputStream(resin, "\n=", ';');
	in->setAutoTrim(true);
	in->setIgnoreComments(true);
	
	if(in->fail())
	{ delete in; return false; }

	String curSecName, curOption, curValue;
	IniSection curSection;

	String curLine;

	// skip front where there's nothing interesting
	while(!in->eos() && (!(curLine = in->getLine()).startsWith("[")));
	if(in->eos()) { delete in; return false; }
	
	// found first section
	curSecName = curLine.substring(1, curLine.length() - 1);
	
	while(!in->eos()) {
		curLine = in->getLine();
		if(curLine.length() == 0) continue; // ignore empty lines
		if(curLine.startsWith("[")) { // new section
			addSection(curSecName, curSection);
			curSection.clear();
			curSecName = curLine.substring(1, curLine.length() - 1);
		}
		else { // option
			int eqIndex = curLine.indexOf('=');
			if(eqIndex <= 0) continue;
			curOption = curLine.substring(0, eqIndex);
			curValue = curLine.substring(eqIndex + 1);
			curSection[curOption] = curValue;
		}
	}

	// add last section
	addSection(curSecName, curSection);

	bool ret = !(in->fail());
	delete in;
	return ret;
}

bool IniFile::write(const String& filename)
{
	FileOutputStream *out = new FileOutputStream(filename);
	if(out->fail()) { delete out; return false; }

	String line;
	for(StringMap<IniSection>::Iterator sects = data.begin(); sects.hasElement(); ++sects)
	{
		line = "\n["; line += (*sects).getKey(); line += "]\n"; 
		out->write(line);

		for(IniSection::Iterator opts = (*sects).getValue().begin(); opts.hasElement(); ++opts)
		{
			line = (*opts).getKey(); line += '='; line += (*opts).getValue(); line += '\n';
			out->write(line);
		}
	}

	bool ret = !(out->fail());
	delete out;
	return ret;	
}


} // namespace

