#ifndef __LRT_ITERATOR_TEMPL__
#define __LRT_ITERATOR_TEMPL__

#include "rtiterator.h"

namespace lrt {

template<class LRT_NPTR(T)> void deleteCurrent(Iterator<LRT_PTR(T)>& pos)
{
	if(!pos.canModify()) return;
	if(!pos.hasElement()) return;
	delete pos.get();
	pos.remove();
}

template<class LRT_NPTR(T)> void deleteAll(Iterator<LRT_PTR(T)> begin)
{
	if(!begin.canModify()) return;
	while(begin.hasElement()) {
		delete begin.get();
		begin.remove();
	}
}

}

#endif
