#include "rtresource.h"

#include "rtmap.h"
#include "rtfile.h"
#include "rtstreams.h"

namespace lrt{


StringMap<lrt_resource_type> Resource::resources;

void Resource::addResource(const lrt_resource_type& res)
{
	resources.put(res.name, res);
}

InputStream* Resource::getResource(const String& name)
{
	File file(name);
	if(file.exists())
		return new FileInputStream(file, false);
	if(resources.isSet(name))
		return new ResourceInputStream(resources.get(name));
	
	return 0;
}

/** ResourceInputStream */

ResourceInputStream::ResourceInputStream(const lrt_resource_type& res) : 
	resource(res), pos(0), markPos(0)
{	
}

int ResourceInputStream::read()
{
	if(pos < resource.length)
		return resource.data[pos++];
	return -1;
}

bool ResourceInputStream::eos()
{
	if(pos < resource.length)
		return false;
	else 
		return true;
}

bool ResourceInputStream::markSupported()
{
	return true;
}

void ResourceInputStream::mark()
{
	markPos = pos;
}

void ResourceInputStream::reset()
{
	pos = markPos;
}


} // namespace

