/** \file 
  * This file is only used for the EPOC implementation of LibRT.
  */

#ifdef __SYMBIAN32__

// TUIEDIT.H
//
// Copyright (c) 1998 Symbian Ltd.  All rights reserved.
//


#ifndef __TUIEDIT_H
#define __TUIEDIT_H

#include <e32cons.h>

/*
	CLineEdit class - borrowed from F32 text window server
*/

class CLineEdit : public CBase
    {
public:
	enum TCursorType {ECursorNone=0,ECursorNormal=20,ECursorInsert=100};
	enum TEditMode {EEditOverWrite,EEditInsert};
public:
	IMPORT_C static CLineEdit* NewL(CConsoleBase* aConsole,TInt aMaxHistory);
	~CLineEdit();
	IMPORT_C void Edit(const TDesC& aPrompt,TDes* aBuf);
protected:
	CLineEdit();
	TPoint Where();
	TInt Lines();
	TInt WordLeft();
	TInt WordRight();
	void ClearLine();
	void ClearLast(TInt aCnt);
	void Recall();
	void Cursor();
	void Refresh();
	inline TDes& Buf() {return *iBuf;}
private:
	CArrayFixFlat<HBufC*>* iHistory;
	CConsoleBase* iConsole; // Not owned
	TInt iMaxHistory;
	TInt iWidth;
	TInt iHeight;
	TInt iPos;
	TInt iLine;
	TInt iOrigin;
	TInt iRecall;
	TEditMode iMode;
	TDes* iBuf;
	};

#endif


#endif // __SYMBIAN32__

