#ifndef __RT_ROBLOADER__
#define __RT_ROBLOADER__

#include <rtstring.h>
//#include <rtstreams.h>

#include "robbase.h"
#include "robvars.h"
#include "robdefines.h"

using namespace lrt;

namespace rt {

class RobLoader : public ProgramLoader {
public:
	// example constructor
	RobLoader(const ErrorHandler* handler);
	virtual ~RobLoader();

	virtual ProgramLoader* create(const String& filename, const Globals& glob);
	virtual bool canLoad(const String& filename);
	virtual String getFormatName();

protected:
	virtual LoadReturnType load();
	virtual LoadReturnType loadHeaders();

private:
	// we'll use it so often...
	typedef Instr::Op Op;

	// concrete constructor
	RobLoader(const RobLoader* example, const String& filename, const Globals& glob);
	bool isExample;

	StringMap<rint> labels;

	// converts our error to the generic ProgramLoader error
	LoadReturnType error(RobLoadReturnType num, DefineInputStream* in);

	/// after finishing, file position is before first "Bank" or "Define" in file
	RobLoadReturnType doLoadHeaders(DefineInputStream* in);
	RobLoadReturnType mkOldHeader(DefineInputStream* in, const String& name);
	RobLoadReturnType mkNewHeader(DefineInputStream* in, HeaderType type);

	RobLoadReturnType doLoad(DefineInputStream* in);
	RobLoadReturnType getLabels(DefineInputStream* in);
	RobLoadReturnType readOps(DefineInputStream* in, Array<Op>& ops, bool* dest);
	RobLoadReturnType convertParamDest(const String& word, Op& op);
	RobLoadReturnType convertParamSrc(const String& word, Op& op);
};



} // namespace

#endif

