// robrating.h: Schnittstelle fr die Klasse RatingPlugin.
//
//////////////////////////////////////////////////////////////////////

#ifndef __RT_RATING__
#define __RT_RATING__

#include "robfrontend.h"
#include "robmanage.h"
#include "robbase.h"

#include <rtsystem.h>

using namespace lrt;

namespace rt {

class RatingPlugin : public FrontendPlugin  
{
public:
	virtual FpInterpretePos getInterpretePos();
	virtual String getName();
	virtual String getHelpText();
	virtual bool interpreteParams(const Array<String>& params, Array<bool>& used);
	virtual void fillOptions(SimOptions& options);
	RatingPlugin(Frontend* parent);
	~RatingPlugin() {}
private:
	int endCycles;
};

class RatingSimSupervisor : public SimSupervisor 
{
public:
	RatingSimSupervisor(int endCycles);
	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual GameState exec(Simulation* const curSim);
	virtual void exitSim(Simulation* const curSim, const GameState& simResult);
private:
	int endCycles;
	GameState retState;
};

} // namespace

#endif

