/*
 * rtsound.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// rtsound.cpp: Implementierung der Klasse Sound.
//
//////////////////////////////////////////////////////////////////////

#include "rtsound.h"
#include "rtstring.h"
#include "rtfile.h"

// actual implementation

#ifdef __WIN32__
  #include "rtsound.win32.cpp"
#else
  #ifdef __UNIX__
    #include "rtsound.unix.cpp"
  #else
    #include "rtsound.nosound.cpp"
  #endif // __UNIX__
#endif //__WIN32__

// system-independent functions

namespace lrt {

Vector<String> Sound::extraSoundFolders; 

void Sound::addSoundFolder(const String& folder)
{
	String fx = folder; 

	if(!File(folder).isFolder())
		fx += File::separator; 

	extraSoundFolders += fx; 
}

String Sound::resolve(const String& logicalSoundName)
{
	String soundfile = logicalSoundName.replace('/', File::separatorChar);
	soundfile += getExtension();

	String soundfolder("sounds");
	soundfolder += File::separator;
	File execfolder = File::getExecutableFile().getParentFile();

	if(File(soundfile).exists()) return soundfile;

	if(File(execfolder, soundfile).exists()) 
		return execfolder.getName() + soundfile;
	if(File(execfolder, soundfolder + soundfile).exists()) 
		return execfolder.getName() + soundfolder + soundfile;

	for(int i = 0; i < extraSoundFolders.length(); i++) 
		if(File(extraSoundFolders[i] + soundfile).exists())
			return extraSoundFolders[i] + soundfile; 

	return String();
}

bool Sound::isPresent(const String& logicalSoundName)
{
	return (resolve(logicalSoundName) != "");
}


} // namespace
