/*
 * robconsole.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file robconsole.h
  * All Console specific stuff for RoboTour.
  */

#ifndef __RT_ROBCONSOLE__
#define __RT_ROBCONSOLE__

#include "robfrontend.h"
#include "robmanage.h"

#include <rtcollect.h>
#include <rtstring.h>
#include <rtsystem.h>

namespace rt {

class ConsoleFrontend;
class ConsoleBotPresenter;
class FieldPrinter;
class DebugPrinter;

/// Given a string of the format "+----+---------+------", 
/// takes the difference of the positions of adjacent plus characters and 
/// stuffs them into the returned array. 
/// @param minCols How many columns do you want to have? 
lrt::Array<int> getColWidths(const lrt::String& header, int numCols);

class ConsoleFrontend : public Frontend {

public:
	ConsoleFrontend();
	virtual ~ConsoleFrontend();

	// from ErrorHandler
	virtual void handleLoadError(const lrt::String& affectedFile, const lrt::String& message) const;
	virtual void handleBotError(const Bot* affectedBot, ExecReturnType type) const;
	virtual void handleSystemError(int num, const lrt::String& message) const;
	virtual void handleWarning(const lrt::String& message) const;

	virtual bool interpreteParamsImpl(const lrt::Array<lrt::String>& params, lrt::Array<bool>& used);
	virtual void fillOptions(SimOptions& options);

protected:
	class MyTourDisplayer : public TourDisplayer {
	public:
		MyTourDisplayer(ConsoleBotPresenter* cbp = 0);
		virtual void init(const TourInitInfo&);
		virtual TourStatusType update(const lrt::Array<TourResult>& status);
		virtual void exit(TourStatusType exitType, const lrt::Array<TourResult>& result);

	private:
		lrt::Time starttime;
		ConsoleBotPresenter* cbp;
	};
	int verbose;
	int printtime;
	int debugtime;
	lrt::String debugrange;

	void printHelp();
	void printVersion(); 
};

class ConsoleBotPresenter : public SimSupervisor {

public:
	ConsoleBotPresenter(bool verbose);
	virtual ~ConsoleBotPresenter();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);
	virtual void exitSim(Simulation* const sim, const GameState& simResult);
	void initTour(const TourInitInfo&);

private:
	int simNum, simCount;
	bool verbose;
	GameState retState;
};

class FieldPrinter : public SimSupervisor {

public:
	FieldPrinter(int printtime);
	virtual ~FieldPrinter();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	int printtime;
	GameState retState;
	lrt::String boundary;
};


class DebugPrinter : public SimSupervisor {

public:
	DebugPrinter(int debugtime, lrt::String debugrange);
	virtual ~DebugPrinter();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	int debugtime;
	int sx, sy, ex, ey;
	GameState retState;
};


} // namespace

#endif

