/*
 * robpackage.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares functions to find data files
  */

#ifndef __RT_ROBPACKAGE_H__
#define __RT_ROBPACKAGE_H__

#include <rtstring.h>

namespace rt {

// Should be called at startup, after lrt was initialized!
void initPackage(); 

// Search for an option set
// "file" may be an absolute path and file name, but will normally be just a file name (without path)
// For option sets, ressources are allowed too. 
lrt::String findOptionSet(const lrt::String& file);

// The sound finding is done by lrt::Sound itself. 
//lrt::String findSound(const lrt::String& baseName);

/// Finds a help file with the given file name. 
/// "file" may be an absolute path and file name, but will normally be just a file name (without path).
/// By preference, we'll try to find a translated help file.
/// @see getLanguageCode()
/// @return Path of an existing help file with the given file name, or the empty string 
///         if it can't be found. 
lrt::String findHelpFile(const lrt::String& file);



} // namespace 

#endif // file
