/*
 * robvis.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// visualization related non-GUI classes (sim-supervisors, tournament handlers)

#ifndef __RT_LRTVIS__
#define __RT_LRTVIS__

#include "robwxfe.h"
#include "robmanage.h"
#include "robbase.h"
#include "robwxstruct.h"

#include <rtsystem.h>
#include <rtstreams.h>

class wxEvent;
class wxStopWatch;

namespace rt {


// helper functions
// mini helpie function: checks if we have a frame to do something for
bool HaveVisFrame();
// helpey function: waits until the event was really processed
// maxWait: max time to wait (msec)
// ALWAYS use this one!
void PostAndWait(wxEvent& evt, int maxWait = 1000);
// special value for maxWait
enum {
	WaitInfinite = -1
};

// predeclasses
class VisPlugin;
class VisSupervisor;
class VisTourDisplayer;
class VisDebugSupervisor;

// classes
class VisPlugin : public FrontendPlugin  
{
public:
	virtual FpInterpretePos getInterpretePos();
	virtual lrt::String getCodeName();
	virtual lrt::String getName();
	virtual lrt::String getHelpText();
	virtual bool interpreteParams(const lrt::Array<lrt::String>& params, lrt::Array<bool>& used);
	virtual void fillOptions(SimOptions& options);
	VisPlugin(Frontend* parent);
	~VisPlugin();
private:
};

class VisSupervisor : public SimSupervisor
{
public:
	VisSupervisor(Frontend* parent, VisDebugSupervisor* debugger = 0);
	~VisSupervisor();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const curSim);
	virtual void exitSim(Simulation* const curSim, const GameState& simResult);
	void updateTour(const lrt::Array<TourResult>& tourStatus);

private: 
	friend class VisTourDisplayer;

	void processGuiRequests(Simulation* sim);
	void processSoundRequest(SoundRequest* req); 

	lrt::Vector<TourResult> tourStatus; 
	TourInitInfo initInfo;
	int curSimNum; 

	wxStopWatch* watch;

	VisDebugSupervisor* debugger;
	Frontend* parent; 
};

class VisTourDisplayer : public TourDisplayer {

public:
	VisTourDisplayer(VisSupervisor* super);

	virtual TourStatusType update(const lrt::Array<TourResult>& status);
	virtual void init(const TourInitInfo& info) { super->initInfo = info; super->curSimNum = 0; }
	virtual void exit(TourStatusType exitType, const lrt::Array<TourResult>& result) {}
private:
	VisSupervisor* super;
};


class VisDebugSupervisor : public SimSupervisor, public BotErrorHandler 
{
public:
	VisDebugSupervisor(Frontend* parent);
	~VisDebugSupervisor();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const curSim);
	virtual void exitSim(Simulation* const curSim, const GameState& simResult);
	virtual void handleBotError(const Bot* affectedBot, ExecReturnType type);

private: 
	// process my own (debug) requests -- called by the VisSupervisor
	void processGuiRequest(Simulation* sim, DebugRequest* req); 
	friend class VisSupervisor;

	lrt::Map<int, DebugInfo> debugInfo;
	int nextDebugID;
	WxFrontend* parent; // can be 0 (if another frontend is being used)
};

} // namespace

#endif

