/*
 * (C) Finite State Machine Labs Inc. 2000 business@fsmlabs.com
 *
 * Released under the terms of GPL 2.
 * Open RTLinux makes use of a patented process described in
 * US Patent 5,995,745. Use of this process is governed
 * by the Open RTLinux Patent License which can be obtained from
 * www.fsmlabs.com/PATENT or by sending email to
 * licensequestions@fsmlabs.com
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <rtlinux_signal.h>

float marker = 0;
volatile float *marker_ptr = &marker;

void handler(int unused)
{
	*marker_ptr = .5;
	*marker_ptr += .25;
}

int main(void)
{
	struct rtlinux_sigaction sig, oldsig;
	rtlinux_sigset_t myset, oldset;

	/* setup for a test of floating point */
	sig.sa_handler = handler;
	sig.sa_flags = RTLINUX_SA_ONESHOT;
	sig.sa_period = NSECS_PER_SEC / 4;

	/* install our handler for oneshot */
	if (rtlinux_sigaction(RTLINUX_SIGTIMER0, &sig, &oldsig)) {
		perror("rtlinux_sigaction");
		return errno;
	}

	/* wait for the _handler_ to go off plus a bit extra in case
	 * oneshot is messing up and becoming periodic
	 */
	sleep(2);

	if (marker != (0.75))
		fprintf(stderr, "marker is %f\n", marker);

	/* free the timer */
	sig.sa_handler = RTLINUX_SIG_IGN;
	if (rtlinux_sigaction(RTLINUX_SIGTIMER0, &sig, &oldsig)) {
		perror("rtlinux_sigaction");
		return errno;
	}

	return 0;
}
