/*
 * action.h
 *
 *  Created on: 04.12.2009
 *      Author: offtools
 */

#ifndef __ACTION_H__
#define __ACTION_H__

// TODO (offtools#1#): validate new actions (test waypoints, spawns ...)

struct ActionLib;
struct ActionInstance;
struct Control;

//----------------Action Types-----------------
struct GenericAction
{
    GenericAction();
	virtual void process(Control& target) = 0;
    void finished(Control& target);
};

struct ActionSpawn : GenericAction
{
    int ent;

    ActionSpawn(int uid);
    void process(Control& target);
};

struct ActionWait : GenericAction
{
	int millis;

	ActionWait(int _millis);
	void process(Control& target);
};

struct ActionMove : GenericAction
{
	int ent;

	ActionMove(int uid);
	void process(Control& target);
};

struct ActionSpeed : GenericAction
{
	int speed;

	ActionSpeed(int _speed);
	void process(Control& target);
};

struct ActionDestroy : GenericAction
{
	ActionDestroy();
	void process(Control& target);
};

struct ActionModel : GenericAction
{
	int model;

	ActionModel(int model);
	void process(Control& target);
};

struct ActionSetAO : GenericAction
{
	int ao;
	int anim;

	ActionSetAO(int _ao, int _anim);
	void process(Control& target);
};

struct ActionSetGesture : GenericAction
{
	int anim;

	ActionSetGesture(int anim);
	void process(Control& target);
};

struct ActionDoGesture : GenericAction
{
	int millis;

	ActionDoGesture(int millis);
	void process(Control& target);
};

struct ActionAttach : GenericAction
{
	int part;
    int rule;
    string model;

	ActionAttach(int part, char* model, int rule);
	void process(Control& target);
};

struct ActionDetach : GenericAction
{
	int part;

	ActionDetach(int part);
	void process(Control& target);
};
//-------------Action Managment----------------
struct ActionState
{
	string statedescr;
	vector <GenericAction*> steps;

	ActionState(const char*  descr);

	~ActionState();

	const char* getstatedescr() { return statedescr; }

	bool hasstep(int i);

	void append(GenericAction *a);

	void insert(int pos, GenericAction *a);

	void remove(int pos);

	GenericAction* getaction(int i);
};

struct ActionLib
{
    int usage;
	string librarydescr;
	vector<ActionState*> states;

	ActionLib(const char* descr);

	~ActionLib();

	bool hasstep(int state, int step);

	bool hasnextstep(int state, int step);

	bool hasstate(int state);

	//returns the Action of the requested step in requested state
	GenericAction* getaction(int state, int step);

	//returns the requested state
	ActionState* getstate(int state);

	//preserves a new state - returns number of states
	int addstate(const char *descr);

    //append a new step on given state
	void appendstep(int state, GenericAction* action);

    //insert step on current position
	void insertstep(int state, int step, GenericAction* action);

    //notify running instances about changed
    void notify(int ev);

	//notify running instances about destroy
	void notifydelete();
};


//action states (refers to action instances)
enum {
    ACTION_STATE_IDLE = 0,
    ACTION_STATE_INIT,
    ACTION_STATE_PROCESS,
    ACTION_STATE_END
};

//following events can be handled by actioninstance:
//general: ActionLib has changed, own operation like reached last step
enum {
    ACTIONINSTANCE_EVENT_SPAWN = 0,
    ACTIONINSTANCE_EVENT_INIT,
    ACTIONINSTANCE_EVENT_STEP_APPEND,
    ACTIONINSTANCE_EVENT_STEP_DELETE,
    ACTIONINSTANCE_EVENT_STEP_FINISH,
    ACTIONINSTANCE_EVENT_STATE_APPEND,
    ACTIONINSTANCE_EVENT_STATE_DELETE,
    ACTIONINSTANCE_EVENT_STATE_FINISH
};

//policies, how to hanlde certain events
enum
{
    ACTION_POLICY_ON_STATE_END_WAIT = 1<<0,
    ACTION_POLICY_ON_STATE_END_LOOP = 1<<1,
    ACTION_POLICY_ON_STATE_END_NEXT = 1<<2,
    ACTION_POLICY_ON_LAST_STATE_END_DESTROY = 1<<3,
    ACTION_POLICY_ON_LAST_END_STATE_IDLE = 1<<4,
    ACTION_POLICY_ON_LAST_STATE_END_LOOP = 1<<5
};

//TODO: set localuid in contructor
class ActionInstance
{
public:
	ActionLib& lib;
	int curstate;	    //index of current state
	int curstep;	    //index of current step
	int lastaction;     //time on changing step
    int actionstate;    //states, process, idle, end ...
    int actionpolicy;   //sets behaviour on finishing a state: stop, nextstate, or loop
	int localuid;		//return value for scripts on adding character in default mode (see addcharacter)

	ActionInstance(ActionLib& _lib);

	~ActionInstance();

	int getcurstate();

	int getcurstep();

	int getlastaction();

	void setcurstate(int state);

    void event(int ev);

    void finished();

	void next();

	void process(Control& target);

	void nextstep(Control& target);

	void laststep(Control& target);
};

void clearactions();

#endif /* __ACTION_H__ */
