#!/usr/bin/perl
#
# version 3, Sun Aug 13 21:19:26 1995, last mod by wietse
#

#
# Run an off-the-shelf HTML client against a dedicated HTML server.  The
# server executes PERL files that are specified in HTML requests.
#
# Authentication is magic-cookie style via the file system.  This should
# be good enough: the client-server conversation never goes over the
# network so the magic cookie cannot be stolen by a network sniffer.
# 
# Values in POST attribute-value lists are assigned to the corresponding
# global PERL variables.  See &process_html_request() for details.
#

sub html {
	local($helper, $wd, $host, $start);

         $_ = $MOSAIC ;
         unless (/\/lynx$/) {
            $_ = $ENV {'DISPLAY'} ;
            if (/^$/) {
               print "ERROR: You need to set the DISPLAY environment variable!\n";
                exit 2; }
            unless (/:[0-9]+$/ || /:[0-9]+\.[0-9]+$/) {
              print "ERROR: The DISPLAY variable must be set properly!\n" ;
              exit 2; }
         }

	#
	# Start the HTML server and generate the initial cookie for
	# client-server authentication.
	#
	$running_from_html = 1;
	chmod 0700, <~/.mosaic*>;	# Yuck!
	chmod 0700, <~/.netsca*>;	# Yuck!
	chmod 0700, <~/.MCOM*>;		# Yuck!
	&start_html_server();
	&make_password_seed();

	#
	# These strings are used in, among others, PERL-to-HTML scripts.
	# Try to speak HTML via the localhost interface (except with lynx).
	#
	$wd = `pwd`;
	chop $wd;
	$html_root = "$wd/html";
	$html_root=~s/\/usr\/lib/\/var\/lib/;
	$start_page = "satan.html";
	die <<EOF
Can't get my fully-qualified name. Set \$dont_use_nslookup in $SATAN_CF 
and try again.\n
EOF
	    unless $THIS_HOST = &getfqdn(&hostname());
	$HTML_HOST = ($MOSAIC =~ /lynx/) ? $THIS_HOST : "localhost";
	$html_client_addresses = find_all_addresses($HTML_HOST) ||
	    die "Can't find all addresses for $HTML_HOST\n";
	$HTML_ROOT = "file://localhost$html_root";
	$HTML_SERVER = "http://$HTML_HOST:$html_port/$html_password$html_root";
	$HTML_STARTPAGE = "$HTML_ROOT/$start_page";

	#
	# Some obscurity. The real security comes from magic cookies.
	#

	for (<$html_root/*.pl>) {
	    s/\.pl$//;
	    unlink "$_.html";
	    open(HTML, ">$_.html")
		    || die "cannot write $_.html: $!\n";
	    select HTML;
	    do "$_.pl";
	    close HTML;
	    select STDOUT;
	    die $@ if $@;
	}

	#
	# Fork off the HTML client, and fork off a server process that
	# handles requests from that client. The parent process waits
	# until the client exits and terminates the server.
	#
	die "Sorry, reconfig did not find any web browser\n" unless $MOSAIC;
	print "Starting $MOSAIC...\n" if $debug;

	if (($client = fork()) == 0) {
		foreach (keys %ENV) {
			delete $ENV{$_} if (/proxy/i && !/no_proxy/i);
		}
		exec($MOSAIC, "$HTML_STARTPAGE") 
			|| die "cannot exec $MOSAIC: $!";
	} 
	if (($helper = fork()) == 0) {
		alarm 3600;
		&patience();
	}
	if (($server = fork()) == 0) {
		&init_satan_data();
		&read_satan_data() unless defined($opt_i);
		kill 'TERM',$helper;
		$SIG{'PIPE'} = 'IGNORE';
		for (;;) {
			accept(CLIENT, SOCK) || die "accept: $!";
			select((select(CLIENT), $| = 1)[0]);
			&process_html_request();
			close(CLIENT);
		}
	}

	#
	# Wait until the client terminates, then terminate the server.
	#
	$start = time();
	close(SOCK);
       #
       # big problem, some netscape versions fork (particularrly under
       # linux) and there is no chance prevent this ...
       # so we scan the process table ....
       #
       local ($test_init_fork)    =  1 ;
       local ($wait_fork_counter) =  5 ;
       local ($ps_cmd)            = "/bin/ps xjw" ;
       local ($ppid_inx)          = 1 ;
       local ($pid_inx)           = 2 ;

       # get the base name, the command may be a shell script
       @a = split (/\//, $MOSAIC) ;
       $_ = $a [$#a] ;

       # strip an optional "-version" tag
       s?-[0-9]*\.[0-9][0-9a-z]*?? ;
       $MOSAIC = $_ ;

       for (;;) {
           open (PS, $ps_cmd . "|") || die "Can't exec `$ps_cmd'" ;
           local ($mosaic) = 0 ;
           local ($Mosaic) ;
           while (<PS>) {
               next unless /$MOSAIC/ ;
               next unless /$HTML_STARTPAGE/ ;
               local (@a) = split (/[\s\t]+/, $_) ;

               # there should be at most one instance ...
                 if ($mosaic && $mosaic != $a [$ppid_inx]) {
                   next if $Mosaic == $a [$pid_inx] ;
                   # no chance, killing the server is the least problem
                   # (only the cient would not work here ...)
                   close (PS);
                   goto do_waitpid
               }
               $mosaic = $a  [$pid_inx] ;
               $Mosaic = $a [$ppid_inx] ;
           }
           close (PS);
           next unless $mosaic ;

           # check for a different pid i.e. wait for a fork
           if ($mosaic == $client) {
               last if $wait_fork_counter -- <= 0 ;
               sleep (30) ;
               next ;
           }
           # some versions of netscape detach completely
           if ($test_init_fork -- > 0 && $Mosaic > 1) {
               sleep (30);
               next;
           }

           print "Waiting/monitoring $MOSAIC (pid=$mosaic) ...\n";
           for (;;) {
               sleep (30);
               next if kill 0, $mosaic ;
               print "Done.\n";
               kill('TERM', $server);
               exit ;
           }
       }

       do_waitpid:
       print "Waiting for client to die (pid=$clinet) ...\n";


	waitpid($client, 0);
	kill('TERM', $server);
	kill('TERM', $helper);
	warn <<EOF
$MOSAIC terminated earlier than expected. Perhaps it is a wrapper
or script that places the browser program into the background? When
that is the case, edit config/paths.pl and change the line with

	\$MOSAIC="/path/to/browser";

so that it points to the browser program directly.
EOF
	if ($? == 0 && time() - $start < 5);
	exit;
}

#
# Compute a hard to predict number for client-server authentication. Exploit
# UNIX parallelism to improve unpredictability. We use MD5 only to compress
# the result.
#
sub make_password_seed {
	local($command);

	die "Cannot find $MD5. Did you run a \"reconfig\" and \"make\"?\n"
		unless -x "$MD5";
	$command = "$PS axl&ps -el&$NETSTAT -na&$NETSTAT -s&$LS -lLRt /dev&w";
	open(SEED, "($command) 2>/dev/null | $MD5 |")
		|| die "cannot run password command: $!";
	($html_password = <SEED>) || die "password computation failed: $!";
	close(SEED);
	chop($html_password);
}

#
# Set up a listener on an arbitrary port. There is no good reason to
# listen on a well-known port number.
#
sub start_html_server {
	local($sockaddr, $proto, $junk);

	$sockaddr = 'S n a4 x8';
	($junk, $junk, $proto) = getprotobyname('tcp');
	socket(SOCK, &AF_INET, &SOCK_STREAM, $proto) || die "socket: $!";
	# Some System V versions won't listen on unbound ports
	bind(SOCK, pack($sockaddr, &AF_INET, 0, "\0\0\0\0")) || die "bind: $!";
	listen(SOCK, 1) || die "listen: $!";
	($junk, $html_port) = unpack($sockaddr, getsockname(SOCK));
}

#
# Process one client request.  We expect the client to send stuff that
# begins with:
#
#	command /password/perl_script junk
#
# Where perl_script is the name of a perl file that is executed via
# do "perl_script";
#
# In case of a POST command the values in the client's attribute-value
# list are assigned to the corresponding global PERL variables.
#
sub process_html_request {
	local($request, $command, $script, $magic, $url, $peer);
	local(%args);

	#
	# Parse the command and URL.
	#
	$request = <CLIENT>;
	print $request if $debug;
	($command, $url) = split(/\s+/, $request);
	if ($command eq "" || $command eq "QUIT") {
		return;
	}

	($url = &html_unhex($url)) =~ s/\.html$//;
	($junk, $magic, $script) = split(/\//, $url, 3);
	($script, $html_script_args) = split(',', "/$script", 2);

	#
	# Make sure they gave us the right magic number.
	#
	if ($magic ne $html_password) {
		&bad_html_magic($request);
		return;
	}

	#
	# Assume the password has leaked out when the following happens.
	#
	$peer = &get_peer_addr(CLIENT);
	die "SATAN password from unauthorized client: $peer\n"
		unless is_member_of($peer, $html_client_addresses);
	die "Illegal script name: $script received from: $peer\n" 
		if index($script ,"/../") >= $[
		|| index($script, "$html_root/") != $[;

	#
	# Warn them when the browser leaks parent URLs to web servers.
	#
	while (<CLIENT>) {
		if (!$cookie_leak_warning && /$html_password/) {
			&cookie_leak_warning();
			return;
		}
		last if (/^\s+$/);
	}

	if ($command eq "GET") {
		perl_html_script($script);
	} elsif ($command eq "POST") {

		#
		# Process the attribute-value list.
		#
		if ($_ = <CLIENT>) {
			s/\s+$//;
			s/^/\n/;
			s/&/\n/g;
			$html_post_attributes = &html_unhex($_);
			%args = ('_junk_', split(/\n([^=]+)=/, $html_post_attributes));
			delete $args{'_junk_'};
			for (keys %args) {
				print "\$$_ = $args{$_}\n" if $debug;
				${$_} = $args{$_};
			}
			perl_html_script($script);
		} else {
			&bad_html_form($script);
		}
	} else {
		&bad_html_command($request);
	}
}


#
# Translate %HEX codes
#
sub html_unhex {
	local($src) = @_;
	local($dst);

	$dst = '';
	$* = 1;
	for (split(/(%[0-9][0-9A-Z])/, $src)) {
		$dst .= (/%([0-9][0-9A-Z])/) ? 
			pack('c',hex($1)) : $_;
	}
	return $dst;
}

#
# Map IP to string.
#
sub inet_ntoa {
	local($ip) = @_;
	local($a, $b, $c, $d);

	($a, $b, $c, $d) = unpack('C4', $ip);
	return "$a.$b.$c.$d";
}

#
# Look up peer address and translate to string form.
#
sub get_peer_addr {
	local($peer) = @_;
	local($junk, $inet);

	($junk, $junk, $inet) = unpack('S n a4', getpeername($peer));
	return &inet_ntoa($inet);
}

# Send html header
# Added by jfs (in order to be able to retrieve .pl files even though
# mailcap says they are perl files)
sub html_header {
	print  CLIENT <<EOF
HTTP/1.0 200
Server: SATAN server
Content-Type: text/html

EOF
}

#
# Wrong magic number.
#
sub bad_html_magic {
	local($request) = @_;
	local($peer);

	$peer = &get_peer_addr(CLIENT);
	print STDERR "bad request from $peer: $request\n";

	&html_header;
        print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>Bad client authentication code</TITLE>
<LINK REV="made" HREF="mailto:satan\@fish.com">
</HEAD>
<BODY>
<H1>Bad client authentication code</H1>
The command: <TT>$request</TT> was not properly authenticated.
</BODY>
</HTML>
EOF
}

#
# Unexpected HTML command.
#
sub bad_html_command {
	local($request) = @_;

	&html_header;
	print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>Unknown command</TITLE>
<LINK REV="made" HREF="mailto:satan\@fish.com">
</HEAD>
<BODY>
<H1>Unknown command</H1>
The command <TT>$request<TT> was not recognized.
</BODY>
</HTML>
EOF
}

#
# Execute PERL script with extreme prejudice.
#
sub perl_html_script {
	local($script) = @_;

	&html_header;
	if (! -e $script) {
		print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>File not found</TITLE>
<LINK REV="made" HREF="mailto:satan\@fish.com">
</HEAD>
<BODY>
<H1>File not found</H1>
The file <TT>$script</TT> does not exist or is not accessible.
</BODY>
</HTML>
EOF
;		return;
	}
	do $script;
	if ($@ && ($@ ne "\n")) {
		print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>Command failed</TITLE>
<LINK REV="made" HREF="mailto:satan\@fish.com">
</HEAD>
<BODY>
<H1>Command failed</H1>
$@
</BODY>
</HTML>
EOF
	}
}

#
# Missing attribute list
#
sub bad_html_form {
	local($script) = @_;

	print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>No attribute list</TITLE>
<LINK REV="made" HREF="mailto:satan\@fish.com">
</HEAD>
<BODY>
<H1>No attribute list</H1>

No attribute list was found.
</BODY>
</HTML>
EOF
}

#
# Scaffolding for stand-alone testing.
#
if ($running_under_satan == 1) {

	require 'perl/socket.pl';
	require 'config/paths.pl';
	require 'perl/hostname.pl';
	require 'perl/getfqdn.pl';
	require 'config/satan.cf';

} else {
	$running_under_satan = 1;

	require 'perl/socket.pl';
	require 'config/paths.pl';
	require 'perl/hostname.pl';
	require 'perl/getfqdn.pl';
	require 'config/satan.cf';

	&html();
}

#
# Give them something to read while the server is initializing.
#
sub patience {
	for (;;) {
		accept(CLIENT, SOCK) || die "accept: $!";
		<CLIENT>;
		&html_header;
		print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>Initialization in progress</TITLE>
<LINK REV="made" HREF="mailto:satan\@fish.com">
</HEAD>
<BODY>
<H1>Initialization in progress</H1>
SATAN is initializing, please try again later.
</BODY>
</HTML>
EOF
;
		close(CLIENT);
	}
}

# Look up all IP addresses listed for this host name, so that we can
# filter out requests from non-local clients. Doing so offers no real
# security, because network address information can be subverted.
# 
# All client-server communication security comes from the magic cookies
# that are generated at program startup time. Client address filtering
# adds an additional barrier in case the cookie somehow leaks out.

sub find_all_addresses {
	local($host) = @_;
	local($junk, $result);

	($junk, $junk, $junk, $junk, @all_addresses) = gethostbyname($host);
	for (@all_addresses) { $result .= &inet_ntoa($_) . " "; }
	return $result;
}

sub is_member_of {
	local($elem, $list) = @_;

	for (split(/\s+/, $list)) { return 1 if ($elem eq $_); }
	return 0;
}

sub cookie_leak_warning {
	&html_header;
	print CLIENT <<EOF;
<HTML>
<HEAD>
<TITLE>Warning - SATAN Password Disclosure</TITLE>
<LINK REV="made" HREF="mailto:satan\@fish.com">
</HEAD>
<BODY>
<H1><IMG SRC="$HTML_ROOT/images/satan.gif" ALT="[SATAN Image]">
Warning - SATAN Password Disclosure</H1>

<HR>

<H3> 

Your Hypertext viewer may reveal confidential information when you
contact remote WWW servers from within SATAN.

<p>

For this reason, SATAN advises you to not contact other WWW servers
from within SATAN.

<p>

For more information, see <a
href="$HTML_ROOT/tutorials/vulnerability/SATAN_password_disclosure.html">the
SATAN vulnerability tutorial</a>.

<p>

This message will appear only once per SATAN session. 

<p>

In order to proceed, send a <i>reload</i> command (Ctrl-R with Lynx),
or go back to the previous screen and select the same link or button
again.

</H3>

</BODY>
</HTML>
EOF
	$cookie_leak_warning = 1;
}

1;
