function Makename=ilib_gen_Make(name,tables,files,libs,makename,with_gateway,ldflags,cflags,fflags)
//------------------------------------
// generate a Makefile for gateway
  if argn(2)<6 then with_gateway=%t,end
  files=strsubst(strsubst(files,'.obj','') ,'.o',''); //compat
  // change table if necessary 
  
  if typeof(tables)<>'list' then 
    tables= list(tables)
  end
  L=length(tables); 
  for it = 1:L 
    table = tables(it);
    [mt,nt]=size(table);
    if nt==2 then col= "csci"; table = [table, col(ones(mt,1))];nt=3; end 
    if nt<>3 then error('second argument has wrong size ');end 
    tables(it)=table;
  end
      
  comp_target = COMPILER;
  if getenv('WIN32','NO')=='OK' then
    select comp_target
     case 'VC++'   then Makename = makename+'.mak'
      ilib_gen_Make_win32(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
     case 'ABSOFT' then Makename = makename+'.amk'
      ilib_gen_Make_win32(name,tables,files,libs,Makename,with_gateway, ...
			  ldflags,cflags,fflags)
     case 'gcc' then 
      Makename = makename;
      ilib_gen_Make_unix(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
    else
       Makename = makename;
       ilib_gen_Make_win32(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
    end
  else
     Makename = makename;
     ilib_gen_Make_unix(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
  end
endfunction

function ilib_gen_Make_unix(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
  fd=mopen(Makename,"w");
  mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------\n");
  mfprintf(fd,"SCIDIR = %s\n",SCI);
  mfprintf(fd,"OBJS = ")
  for x=files(:)' ; 
    mfprintf(fd," %s.o",x);
  end
  
  if typeof(tables)<>'list' then 
    tables= list(tables)
  end

  L=length(tables); 
  
  if with_gateway then 
    if L==1 then 
      mfprintf(fd," %s.o",name);
    else
       for i=1:L , mfprintf(fd," %s.o",name+string(i));end 
    end
  end
  for it=1:L 
    table = tables(it)
    [mt,nt]=size(table);
    for i=1:mt ; 
      // mex files to be added 
      if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' 
	mfprintf(fd," %s.o",table(i,2));
      end
    end
  end
  mfprintf(fd,"\n") ;
  mfprintf(fd,"LIBRARY = %s.a\n",name);
  mfprintf(fd,"include $(SCIDIR)/Makefile.incl\n");
  if getenv('WIN32','NO')=='OK' then
    // for cygwin 
    mfprintf(fd,"OTHERLIBS = ");
    for x=libs(:)' ; mfprintf(fd," %s.a",x);end
    mfprintf(fd,"\n");
    mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	     " -Dmexfunction_=mex$*_  -DmexFunction=mex_$* "+ cflags +" \n"); 
    mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	     " -Dmexfunction=mex$* "+ fflags +"\n"); 
  else
     mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DmexFunction=mex_$* "+cflags+ "\n");
     mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -Dmexfunction=mex$* "+fflags+ "\n");
  end
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+ "\n");
  if getenv('WIN32','NO')=='OK' then
    // cygwin assumed : we use a specific makedll 
    // and not libtool up to now XXX 
    mfprintf(fd,"include $(SCIDIR)/config/Makecygdll.incl\n");
  else
     mfprintf(fd,"include $(SCIDIR)/config/Makeso.incl\n");
  end
  mclose(fd);

endfunction


function ilib_gen_Make_win32(name,table,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
  fd=mopen(Makename,"w");
  mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------\n");
  mfprintf(fd,"SHELL = /bin/sh\n");
  mfprintf(fd,"SCIDIR =%s\n",SCI);
  mfprintf(fd,"SCIDIR1 =%s\n",WSCI);
  mfprintf(fd,"# name of the dll to be built\n"); 
  mfprintf(fd,"LIBRARY = %s\n",name);
  mfprintf(fd,"# list of objects file\n");
  mfprintf(fd,"OBJS =");
  for x=files(:)' ; mfprintf(fd," %s.obj",x);end

  if typeof(tables)<>'list' then 
    tables= list(tables)
  end
  L=length(tables); 

  if with_gateway then 
    if L==1 then 
      mfprintf(fd," %s.obj",name);
    else
       for i=1:L , mfprintf(fd," %s.obj",name+string(i));end 
    end
  end
  
  for it=1:L 
    table = tables(it)
    [mt,nt]=size(table);
 
    for i=1:mt ; 
      // mex files to be added 
      if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' 
	mfprintf(fd," %s.obj",table(i,2));
      end
    end
  end
  mfprintf(fd,"\n# added libraries \n");
  mfprintf(fd,"OTHERLIBS = ");
  for x=libs(:)' ; mfprintf(fd," %s.ilib",x);end
  mfprintf(fd,"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\Makefile.incl.mak\n");
  mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	   " -Dmexfunction_=mex$*_  -DmexFunction=mex_$* "+ cflags +" \n"); 
  mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	   " -Dmexfunction=mex$* "+ fflags +"\n"); 
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\config\\Makedll.incl \n");
  mclose(fd);
endfunction
